//  Copyright 2004 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.contrib.table.model;

import java.util.Iterator;

/**
 * Defines a list model of ITableColumn objects
 * 
 * @version $Id: ITableColumnModel.java,v 1.3 2004/02/19 17:38:04 hlship Exp $
 * @author mindbridge
 */
public interface ITableColumnModel
{
	/**
	 * Method getColumnCount.
	 * @return int the number of columns in the model
	 */
	int getColumnCount();

	/**
	 * Method getColumn.
	 * @param strName the name of the requested column
	 * @return ITableColumn the column with the given name. null if no such column exists.
	 */
	ITableColumn getColumn(String strName);

	/**
	 * Method getColumns.
	 * @return Iterator an iterator of all columns in the model
	 */
	Iterator getColumns();
}
