/***********************************************************
 * A hello world servlet.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.helloworldservlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author lech
 *
 */
public class HelloWorldServlet extends HttpServlet {
    
    private static final long serialVersionUID = 2011032401L;

    public void doGet(HttpServletRequest request,
            HttpServletResponse response)
    throws ServletException, IOException {

        response.setContentType("text/html");

        PrintWriter out = response.getWriter();
        
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        out.println("<html>");
        out.println("  <head><title>Hello World Servlet</title><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf8\" /></head>");
        out.println("  <body>");


        out.println("    <h1>JSDK Request Properties</h1>");
        
        out.println("    <ul>");
        
        Calendar now = GregorianCalendar.getInstance();
        printInfo(out, "Generated at", now.getTime().toString()+"<br/>");
        
        printInfo(out, "Character Encoding", request.getCharacterEncoding());

        printInfo(out, "Context Path", request.getContextPath());

        printInfo(out, "Local Name", request.getLocalName());
        printInfo(out, "Local Port", String.valueOf(request.getLocalPort()));

        printInfo(out, "Locale (prefered by client)", request.getLocale().getDisplayName());

        printInfo(out, "Path Info", request.getPathInfo());
        printInfo(out, "Path Translated", request.getPathTranslated());

        printInfo(out, "Protocol", request.getProtocol());

        String queryString = request.getQueryString();
        if (queryString == null) {
          printInfo(out, "Query String", "NULL");
        } else {
          printInfo(out, "Query String", queryString.replaceAll("&", "&amp;"));
        }

        printInfo(out, "Remote Addr", request.getRemoteAddr());
        printInfo(out, "Remote Host", request.getRemoteHost());
        printInfo(out, "Remote Port", String.valueOf(request.getRemotePort()));
        
        printInfo(out, "Scheme", request.getScheme());

        printInfo(out, "Server Name ", request.getServerName());
        printInfo(out, "Server Port", String.valueOf(request.getServerPort()));
        
        printInfo(out, "Servlet Path", request.getServletPath());

        out.println("    </ul>");

        
        out.println("    <h1>Headers sent by client</h1>");
        out.println("    <ul>");

        @SuppressWarnings("unchecked")
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            Enumeration<String> headerValues = request.getHeaders(headerName);
            int i = 1;
            while (headerValues.hasMoreElements()) {
                String headerValue = headerValues.nextElement();
                String infoName = headerName+"</tt>";
                if (headerValues.hasMoreElements() || (i > 1)) {
                    infoName = infoName + " #" + i;
                    i++;
                } 
                printInfo(out, infoName, headerValue);
            }
        }
        out.println("    </ul>");
        
        out.println("    <h1>Query parameters</h1>");
        Enumeration<String> paramNames = request.getParameterNames();
        if (paramNames == null) {
            out.println("    No query parameters detected (getParameterNames() returned NULL).");
        } else if (!paramNames.hasMoreElements()) {
            out.println("    No query parameters detected (getParameterNames() returned empty list).");
        } else {
            out.println("    <ul>");
            while (paramNames.hasMoreElements()) {
                String paramKey = (String)paramNames.nextElement();
                String[] paramValues = request.getParameterValues(paramKey);
                int i = 1;
                for (String paramValue : paramValues) {
                  printInfo(out, "<tt>"+paramKey+"</tt> ("+i+")", paramValue);
                  i += 1;
                }
            }
            out.println("    </ul>");
        }

        if (request.getParameter("env") == null) {
            out.println("    <!-- param env null -->");
        } else if (!request.getParameter("env").equals("yes")) {
            out.println("    <!-- param env not 'yes' -->");
        } else {
            out.println("    <h1>Environment variables</h1>");
            out.println("    <ul>");
            //@SuppressWarnings("unchecked")
            Map<String, String> envVars = System.getenv();
            for (Map.Entry<String, String> envVar : envVars.entrySet()) {
                String evName = "<tt>"+envVar.getKey()+"</tt>";
                printInfo(out, evName, envVar.getValue());
            }
            out.println("    </ul>");
        }

        out.println("    <h1>More</h1>");
        out.println("    <ul>");
        printInfo(out, "<tt>Real Remote Addr</tt>", detectRealRemoteAddr(request));
        out.println("    </ul>");

        out.println("  </body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    
    protected void printInfo(PrintWriter out, String name, String value) {
        out.print("    <li>"+name+": ");
        if (value == null)
            out.print("NULL");
        else
            out.print("<tt>"+value+"</tt>");
        out.print("    </li>\n");
    }

    public static String detectRealRemoteAddr(final HttpServletRequest request) {
        @SuppressWarnings("unchecked")
        final Enumeration<String> headers = request.getHeaders("X-Forwarded-for");
        if (headers != null) {
            while (headers.hasMoreElements()) {
                final String[] ips = headers.nextElement().split(",");
                for (int i = 0; i < ips.length; i++) {
                    final String realRemoteAddr = ips[i].trim();
                    if (!"unknown".equals(realRemoteAddr) && !realRemoteAddr.isEmpty()) {
                        return realRemoteAddr;
                    }
                }
            }
        }
        return request.getRemoteAddr();
    } 


}


