/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.util.component;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Servlet;
import java.util.concurrent.ScheduledExecutorService;
import org.clazzes.jackson.rpc2.JsonRpcServlet;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.util.component.ServiceListener;
import org.clazzes.svc.util.voc.FieldAccessStrategy;
import org.clazzes.util.aop.ProxyFactory;

public abstract class AbstractDataSourceListener<T>
extends ComponentSupport
implements ServiceListener<T> {
    protected ServiceContext serviceContext;
    protected ServiceRegistry serviceRegistry;

    public AbstractDataSourceListener(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.serviceRegistry = (ServiceRegistry)this.serviceContext.getService(ServiceRegistry.class).get();
    }

    public static ObjectMapper createObjectMapper(FieldAccessStrategy accessStrategy) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (accessStrategy == FieldAccessStrategy.FIELD) {
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        }
        return objectMapper;
    }

    protected void addJsonRpcServlet(String serviceUrl, Object target, Class<?> serviceInterface, String requestThreadLocalKey, FieldAccessStrategy accessStrategy) {
        ObjectMapper objectMapper = AbstractDataSourceListener.createObjectMapper(accessStrategy);
        this.addJsonRpcServlet(serviceUrl, target, serviceInterface, requestThreadLocalKey, objectMapper);
    }

    protected void addJsonRpcServlet(String serviceUrl, Object target, Class<?> serviceInterface, String requestThreadLocalKey, ObjectMapper objectMapper) {
        JsonRpcServlet rpcServlet = new JsonRpcServlet(serviceUrl, serviceInterface, target, requestThreadLocalKey, objectMapper);
        this.addService(this.serviceRegistry, serviceUrl, Servlet.class, rpcServlet);
    }

    protected void addServlet(String serviceUrl, Servlet target, String requestThreadLocalKey) {
        this.addService(this.serviceRegistry, serviceUrl, Servlet.class, target);
    }

    protected <U> void addProxyJsonRpcServlet(ProxyFactory proxyFactory, String serviceUrl, U service, Class<U> serviceInterface, String requestThreadLocalKey, FieldAccessStrategy fieldAccessStrategy) {
        Object serviceProxy = proxyFactory.getTypedProxy(service, serviceInterface);
        this.addJsonRpcServlet(serviceUrl, serviceProxy, serviceInterface, requestThreadLocalKey, fieldAccessStrategy);
    }

    protected <U> void addProxyJsonRpcServlet(ProxyFactory proxyFactory, String serviceUrl, U service, Class<U> serviceInterface, String requestThreadLocalKey, ObjectMapper objectMapper) {
        Object serviceProxy = proxyFactory.getTypedProxy(service, serviceInterface);
        this.addJsonRpcServlet(serviceUrl, serviceProxy, serviceInterface, requestThreadLocalKey, objectMapper);
    }

    protected CoreService getCoreService() {
        return (CoreService)this.serviceContext.getService(CoreService.class).get();
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        CoreService coreService = this.getCoreService();
        return coreService.getScheduledExecutorService();
    }
}

