/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.util.component;

import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.util.component.ConfigListener;
import org.clazzes.svc.util.component.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigListener<C>
extends ComponentSupport
implements ConfigListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigListener.class);
    protected ServiceContext serviceContext;
    protected ServiceRegistry serviceRegistry;

    protected abstract C fetchConfig(ConfigWrapper var1);

    protected abstract void setupBasedOnConfig(ServiceRegistry var1, C var2);

    public AbstractConfigListener(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.serviceRegistry = (ServiceRegistry)this.serviceContext.getService(ServiceRegistry.class).get();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected <T> void addListener(String key, Class<T> iface, ServiceListener<T> serviceListener) {
        this.addListener(this.serviceRegistry.listen(key, iface, service -> serviceListener.handleAdd(this, service), service -> serviceListener.handleRemove(this, service)));
    }

    @Override
    public void accept(ConfigWrapper configWrapper) {
        this.close();
        C config = this.fetchConfig(configWrapper);
        this.setupBasedOnConfig(this.serviceRegistry, config);
    }

    @Override
    public synchronized void closeBusinessLogics() {
        if (log.isDebugEnabled()) {
            log.debug("ConfigListener services for PID [" + this.getPid() + "] have been shut down.");
        }
        this.removeAllServices(this.serviceRegistry);
    }

    @Override
    public void close() {
        this.closeAllListeners();
        this.closeBusinessLogics();
    }
}

