package org.clazzes.svc.util.component;

/** Listener interface for calling org.clazzes.svc.api.ServiceRegistry.listen.
 *  handleAdd is called in the add-Consumer, handleRemove in the remove-Consumer, i.e.
 *  this interface acts as a bridge, such that both methods can be placed in the same class.
 *
 * @param <T> the service at hand
 */
public interface ServiceListener<T> {
	public void handleAdd(ConfigListener configListener, T service);
	public void handleRemove(ConfigListener configListener, T service);
}
