package org.clazzes.svc.util.component;

import java.util.function.Consumer;

import org.clazzes.svc.api.ConfigWrapper;

/** A config listener of a Component.  Implementors in general extend
 *  AbstractConfigListener, and provide the code necessary for running
 *  once the configuration of the Component at hand has been loaded.
 *
 *  See AbstractConfigListener.setupBasedOnConfig, there
 *  the application-specific logic needs to be set up.
 */
public interface ConfigListener extends AutoCloseable, Consumer<ConfigWrapper> {
	/** Returns the Pid of the Component.
	 * @return the pid of the Component
	 */
	public String getPid();

	/** Closes the business logics, i.e. in general calls
	 *  org.clazzes.svc.api.ComponentSupport.removeAllServices(ServiceRegistry)
	 *
	 */
	public void closeBusinessLogics();
}
