package org.clazzes.svc.util.component;

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;

/** The base class for a Component, i.e. the starting point for
 *  configuring what was a Bundle in the old osgi world.
 *
 *  The subclass itself in general just implements a constructor
 *  method for a config listener, which contains the application-specific
 *  code that needs to run once the config of the Component has been loaded.
 *
 *  The Component in general needs to be registered using a statement
 *
 *  <code>
 *  provides Component with ErpImplComponent;
 *  </code>
 *
 *  in the module-info.java of the respective project.
 */
public abstract class AbstractComponent extends ComponentSupport implements Component {

	/** Constructs the ConfigListener for the Component at hand.
	 * @param serviceContext the ServiceContext
	 * @return the constructed ConfigListener
	 */
	protected abstract ConfigListener constructConfigListener(ServiceContext serviceContext);

	@Override
    public void start(ServiceContext serviceContext) throws Exception {
        ConfigurationEngine ce = serviceContext.getService(ConfigurationEngine.class).get();

        ConfigListener cl = this.constructConfigListener(serviceContext);

        // this listener closes the business logics and DB listener.
        this.addListener(cl);
        // this listener closes the config interest.
        this.addListener(ce.listen(cl.getPid(),cl));
	}

	@Override
    public void stop(ServiceContext context) throws Exception {
        this.closeAllListeners();
	}
}
