/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefCountedOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(RefCountedOutputStream.class);
    private final SharedData data;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public RefCountedOutputStream(RefCountedOutputStream other) {
        this((OutputStream)other);
    }

    public RefCountedOutputStream(OutputStream other) {
        if (other instanceof RefCountedOutputStream) {
            RefCountedOutputStream refCounted = (RefCountedOutputStream)other;
            this.data = refCounted.data;
            this.data.refs.incrementAndGet();
        } else {
            this.data = new SharedData(other);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        this.data.underlying.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        this.data.underlying.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        int endRefs = this.data.refs.decrementAndGet();
        if (endRefs <= 0) {
            log.trace("Real close in ref counted input stream for {}", (Object)this.data.underlying);
            this.data.underlying.close();
        }
    }

    public String toString() {
        return "RefCountedOutputStream [refCount=" + this.data.refs.get() + ", underlying=" + String.valueOf(this.data.underlying) + "]";
    }

    private static final class SharedData {
        private final OutputStream underlying;
        private final AtomicInteger refs = new AtomicInteger(1);

        public SharedData(OutputStream underlying) {
            this.underlying = underlying;
        }
    }
}

