/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.clazzes.svc.api.cmd.Argument;
import org.clazzes.svc.api.cmd.CommandSet;
import org.clazzes.svc.api.cmd.Descriptor;
import org.clazzes.svc.api.cmd.Parameter;
import org.clazzes.svc.runner.sshd.CliCommand;
import org.clazzes.svc.runner.sshd.CloseProtectedOutputStream;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandInfo;
import org.clazzes.svc.runner.sshd.CommandResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GogoCommandResolver
implements CommandResolver {
    private static final Logger log = LoggerFactory.getLogger(GogoCommandResolver.class);
    private Supplier<Map<String, CommandSet>> getCommandSets;

    public void setGetCommandSets(Supplier<Map<String, CommandSet>> getCommandSets) {
        this.getCommandSets = getCommandSets;
    }

    private final Function<String, Object> mkConverter(Class<?> clazz) {
        if (clazz == String.class) {
            return s -> s;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer::valueOf;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long::valueOf;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double::valueOf;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean::valueOf;
        }
        if (clazz == URI.class) {
            return URI::create;
        }
        if (clazz == UUID.class) {
            return UUID::fromString;
        }
        if (clazz == Instant.class) {
            return Instant::parse;
        }
        if (clazz == ZonedDateTime.class) {
            return ZonedDateTime::parse;
        }
        if (clazz == OffsetDateTime.class) {
            return OffsetDateTime::parse;
        }
        if (clazz == LocalDateTime.class) {
            return LocalDateTime::parse;
        }
        if (clazz == LocalDate.class) {
            return LocalDate::parse;
        }
        if (clazz == LocalTime.class) {
            return LocalTime::parse;
        }
        if (clazz == ZoneId.class) {
            return ZoneId::of;
        }
        if (clazz == Locale.class) {
            return Locale::forLanguageTag;
        }
        throw new IllegalArgumentException("Cannot coerse string to type [" + String.valueOf(clazz) + "]");
    }

    private final CliCommand mkCommand(CommandSet commandSet, Method method) {
        Options options = new Options();
        String helpText = Objects.requireNonNull(method.getAnnotation(Descriptor.class), "Command did not specify a help text.").value();
        ArrayList<BiFunction<CommandLine, CommandEnvironment, Object>> parameterGetters = new ArrayList<BiFunction<CommandLine, CommandEnvironment, Object>>();
        int positionalIndex = 0;
        StringBuilder footer = new StringBuilder();
        for (java.lang.reflect.Parameter parameterType : method.getParameters()) {
            if (parameterType.getType() == PrintStream.class) {
                parameterGetters.add((cli, env) -> new PrintStream((OutputStream)new CloseProtectedOutputStream(env.stdout()), false, StandardCharsets.UTF_8));
                continue;
            }
            Descriptor paramHelpText = Objects.requireNonNull(parameterType.getAnnotation(Descriptor.class), "Parameter did not specify a help text.");
            Parameter parameter = parameterType.getAnnotation(Parameter.class);
            if (parameter == null) {
                Object name2;
                Argument arg = parameterType.getAnnotation(Argument.class);
                if (positionalIndex < 0) {
                    throw new RuntimeException("Positional argument after rest argument.");
                }
                if (footer.isEmpty()) {
                    footer.append("Positional arguments:\n");
                }
                if (parameterType.getType().isArray()) {
                    int index = positionalIndex;
                    positionalIndex = -1;
                    name2 = arg == null ? "opt" : arg.value();
                    footer.append(String.format(Locale.ENGLISH, " %-16s %s\n", (String)name2 + "...", paramHelpText.value()));
                    Function<String, Object> converter = this.mkConverter(parameterType.getType().getComponentType());
                    parameterGetters.add((cli, env) -> {
                        int remainingArgsSize = cli.getArgs().length - index;
                        Object ret = Array.newInstance(parameterType.getType().getComponentType(), remainingArgsSize);
                        for (int i = 0; i < remainingArgsSize; ++i) {
                            Array.set(ret, i, converter.apply(cli.getArgs()[index + i]));
                        }
                        return ret;
                    });
                    continue;
                }
                int index = positionalIndex++;
                name2 = arg == null ? "arg" + positionalIndex : arg.value();
                footer.append(String.format(Locale.ENGLISH, " %-16s %s\n", name2, paramHelpText.value()));
                Function<String, Object> converter = this.mkConverter(parameterType.getType());
                parameterGetters.add((arg_0, arg_1) -> GogoCommandResolver.lambda$mkCommand$3(index, (String)name2, converter, arg_0, arg_1));
                continue;
            }
            Function<String, Object> converter = this.mkConverter(parameterType.getType());
            List<String> longNames = Arrays.stream(parameter.names()).filter(name -> name.startsWith("--")).map(name -> name.substring(2)).toList();
            List<String> shortNames = Arrays.stream(parameter.names()).filter(name -> name.startsWith("-") && !name.startsWith("--")).map(name -> name.substring(1)).toList();
            boolean isBoolean = !"org.clazzes.svc.api.cmd.unspecified.parameter".equals(parameter.presentValue());
            OptionGroup group = new OptionGroup();
            for (int i = 0; i < Math.max(longNames.size(), shortNames.size()); ++i) {
                Option.Builder builder = Option.builder().desc(paramHelpText.value()).hasArg(!isBoolean);
                if (i < shortNames.size()) {
                    builder = builder.option(shortNames.get(i));
                }
                if (i < longNames.size()) {
                    builder = builder.longOpt(longNames.get(i));
                }
                group.addOption(builder.build());
            }
            options.addOptionGroup(group);
            parameterGetters.add((cli, env) -> converter.apply(cli.hasOption(group) ? (isBoolean ? parameter.presentValue() : cli.getOptionValue(group)) : parameter.absentValue()));
        }
        options.addOption("h", "help", false, "display this help and exit");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        return params -> {
            PrintWriter writer = new PrintWriter(params.stdout(), false, StandardCharsets.UTF_8);
            try {
                CommandLine cli;
                Runnable printHelp = () -> {
                    String syntax = params.arguments().get(0);
                    formatter.printHelp(writer, formatter.getWidth(), syntax, helpText, options, formatter.getLeftPadding(), formatter.getDescPadding(), footer.toString(), true);
                };
                try {
                    cli = parser.parse(options, (String[])params.arguments().subList(1, params.arguments().size()).toArray(String[]::new));
                }
                catch (ParseException e) {
                    writer.println(e.getMessage());
                    printHelp.run();
                    int n = 1;
                    writer.flush();
                    return n;
                }
                if (cli.hasOption("h")) {
                    printHelp.run();
                    int e = 0;
                    return e;
                }
                method.invoke((Object)commandSet, parameterGetters.stream().map(fn -> fn.apply(cli, params.env())).toArray());
                int e = 0;
                return e;
            }
            finally {
                writer.flush();
            }
        };
    }

    private final CliCommand mkCommand(CommandSet commandSet, String command) {
        return this.mkCommand(commandSet, GogoCommandResolver.getClassMethod(commandSet, command));
    }

    private final CliCommand searchCommandSet(CommandSet commandSet, String commandName, CommandEnvironment env) {
        if (commandSet.getCommands().contains(commandName)) {
            try {
                return this.mkCommand(commandSet, commandName);
            }
            catch (Exception e) {
                env.printException(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CliCommand resolveCommand(String commandName, CommandEnvironment env) {
        Map<String, CommandSet> commandSets = this.getCommandSets.get();
        String[] split = commandName.split(":", 2);
        if (split.length < 2) {
            for (CommandSet commandSet : commandSets.values()) {
                CliCommand command = this.searchCommandSet(commandSet, commandName, env);
                if (command == null) continue;
                return command;
            }
            return null;
        }
        CommandSet commandSet = commandSets.get(split[0]);
        if (commandSet == null) {
            return null;
        }
        return this.searchCommandSet(commandSet, split[1], env);
    }

    private static final String helpText(CommandSet commandSet, String commandName) {
        try {
            Method method = GogoCommandResolver.getClassMethod(commandSet, commandName);
            return Objects.requireNonNull(method.getAnnotation(Descriptor.class), "Command did not specify a help text.").value();
        }
        catch (Exception e) {
            log.error("Error while trying to get help text", (Throwable)e);
            return "Error while trying to get help text";
        }
    }

    private static Method getClassMethod(CommandSet commandSet, String commandName) {
        return Arrays.stream(commandSet.getClass().getMethods()).filter(method2 -> method2.getName().equals(commandName)).findFirst().orElseThrow(() -> new IllegalStateException("The CommandSet listed a command that it doesn't have a function for."));
    }

    @Override
    public List<CommandInfo> listCommands(String commandNamePrefix, CommandEnvironment env) {
        Map<String, CommandSet> commandSets = this.getCommandSets.get();
        String[] split = commandNamePrefix.split(":", 2);
        if (split.length < 2) {
            return Stream.concat(commandSets.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(commandNamePrefix)).flatMap(entry -> ((CommandSet)entry.getValue()).getCommands().stream().map(name -> new CommandInfo((String)entry.getKey() + ":" + name, GogoCommandResolver.helpText((CommandSet)entry.getValue(), name)))), commandSets.values().stream().flatMap(commandSet -> commandSet.getCommands().stream().filter(name -> name.startsWith(commandNamePrefix)).map(name -> new CommandInfo((String)name, GogoCommandResolver.helpText(commandSet, name))))).toList();
        }
        CommandSet commandSet2 = commandSets.get(split[0]);
        if (commandSet2 == null) {
            return List.of();
        }
        return commandSet2.getCommands().stream().filter(name -> name.startsWith(split[1])).map(name -> new CommandInfo(split[0] + ":" + name, GogoCommandResolver.helpText(commandSet2, name))).toList();
    }

    private static /* synthetic */ Object lambda$mkCommand$3(int index, String name, Function converter, CommandLine cli, CommandEnvironment env) {
        if (index >= cli.getArgs().length) {
            throw new IllegalArgumentException("Missing argument [" + name + "].");
        }
        return converter.apply(cli.getArgs()[index]);
    }
}

