/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.system;

import java.util.List;
import org.clazzes.svc.api.ComponentInfo;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentState;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class ComponentsHealthCheck
implements HealthCheck {
    private final ComponentManager componentManager;

    public ComponentsHealthCheck(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public HealthInfo call() throws Exception {
        List components = this.componentManager.listComponents();
        HealthStatus status = HealthStatus.HEALTH_CHECK_ERROR;
        int ncommitted = 0;
        for (ComponentInfo comp : components) {
            if (comp.getState() == ComponentState.COMMITTED) {
                if (status == HealthStatus.HEALTH_CHECK_ERROR) {
                    status = HealthStatus.OK;
                }
                ++ncommitted;
                continue;
            }
            if (comp.getState() == ComponentState.STARTED) {
                if (status != HealthStatus.HEALTH_CHECK_ERROR && status != HealthStatus.OK) continue;
                status = HealthStatus.WARN;
                continue;
            }
            status = HealthStatus.CRITICAL;
        }
        String msg = status == HealthStatus.OK ? "All [" + components.size() + "] components are commited." : "Only [" + ncommitted + "/" + components.size() + "] components are commited.";
        return new HealthInfo(status, msg);
    }

    public String getId() {
        return "system.components";
    }

    public String getDescription() {
        return "Check whether all Java components are properly started";
    }

    public List<String> getTags() {
        return List.of("system", "components");
    }
}

