/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.system;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Locale;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.clazzes.svc.runner.monitoring.system.SystemHealthCheckSupport;

public class CPUHealthCheck
extends SystemHealthCheckSupport {
    public CPUHealthCheck(double warningPercentage, double criticalPercentage) {
        super(warningPercentage, criticalPercentage);
    }

    public HealthInfo call() throws Exception {
        double mLoad;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        double cLoad = operatingSystemMXBean.getSystemLoadAverage();
        double percentage = 100.0 * (cLoad / (mLoad = (double)operatingSystemMXBean.getAvailableProcessors()));
        if (percentage < this.warningPercentage) {
            return new HealthInfo(HealthStatus.OK, String.format(Locale.ENGLISH, "CPU usage [%.1f%%<%.1f%%], load [%.2f/%.2f]", percentage, this.warningPercentage, cLoad, mLoad));
        }
        if (percentage < this.criticalPercentage) {
            return new HealthInfo(HealthStatus.WARN, String.format(Locale.ENGLISH, "CPU usage [%.1f%%\u2264%.1f%%<%.1f%%], load [%.2f/%.2f]", this.warningPercentage, percentage, this.criticalPercentage, cLoad, mLoad));
        }
        return new HealthInfo(HealthStatus.CRITICAL, String.format(Locale.ENGLISH, "CPU usage [%.1f%%\u2264%.1f%%], load [%.2f/%.2f]", this.criticalPercentage, percentage, cLoad, mLoad));
    }

    public String getId() {
        return "system.cpu";
    }

    public String getDescription() {
        return "Check the CPU usage against Thresholds [warn=" + this.warningPercentage + "%,critical=" + this.criticalPercentage + "%]";
    }

    public List<String> getTags() {
        return List.of("system", "cpu");
    }
}

