/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.openmetrics;

import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import org.clazzes.svc.runner.monitoring.IActiveMetrics;
import org.clazzes.svc.runner.monitoring.OpenMetricsType;
import org.clazzes.svc.runner.monitoring.Result;

public abstract class OpenMetricsFormatter {
    private static final String POS_INF = Double.toString(Double.POSITIVE_INFINITY);
    private static final String NEG_INF = Double.toString(Double.NEGATIVE_INFINITY);

    protected static final String quote(String s) {
        StringBuilder sb = null;
        int lasti = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\n' && c != '\\' && c != '\"') continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (i > lasti) {
                sb.append(s.substring(lasti, i));
            }
            lasti = i + 1;
            if (c == '\n') {
                sb.append("\n");
                continue;
            }
            sb.append('\\');
            sb.append(c);
        }
        if (sb == null) {
            return s;
        }
        if (lasti < s.length()) {
            sb.append(s.substring(lasti));
        }
        return sb.toString();
    }

    protected static final String formatNumber(Number n) {
        String s = n.toString();
        if (n instanceof Double) {
            if (s == POS_INF) {
                return "+Inf";
            }
            if (s == NEG_INF) {
                return "-Inf";
            }
        }
        return s;
    }

    protected static void formatCounter(Appendable w, String id, IActiveMetrics<?> metrics) throws IOException {
        Result<?> r = metrics.getResult();
        double created = (double)metrics.getCreatedMillis() * 0.001;
        if (r == null) {
            w.append(id + "_created " + OpenMetricsFormatter.formatNumber(created) + "\n");
        } else {
            double timestamp = (double)r.getEpochMillis() * 0.001;
            w.append(id + "_total " + OpenMetricsFormatter.formatNumber(r.getNumericResult()) + " " + OpenMetricsFormatter.formatNumber(timestamp) + "\n");
            w.append(id + "_created " + OpenMetricsFormatter.formatNumber(created) + "\n");
        }
    }

    protected static void formatGauge(Appendable w, String id, IActiveMetrics<?> metrics) throws IOException {
        Result<?> r = metrics.getResult();
        if (r != null) {
            double timestamp = (double)r.getEpochMillis() * 0.001;
            w.append(id + " " + OpenMetricsFormatter.formatNumber(r.getNumericResult()) + " " + OpenMetricsFormatter.formatNumber(timestamp) + "\n");
        }
    }

    protected static void formatSummary(Appendable w, String id, IActiveMetrics<?> metrics) throws IOException {
        SortedMap<Double, Number> sum = metrics.getSummary();
        double created = (double)metrics.getCreatedMillis() * 0.001;
        for (Map.Entry<Double, Number> e : sum.entrySet()) {
            w.append(id + "{quantile=\"" + OpenMetricsFormatter.formatNumber(e.getKey()) + "\"} " + OpenMetricsFormatter.formatNumber(e.getValue()) + "\n");
        }
        w.append(id + "_created " + OpenMetricsFormatter.formatNumber(created) + "\n");
    }

    protected static void formatHistogram(Appendable w, String id, IActiveMetrics<?> metrics) throws IOException {
        SortedMap<Double, Integer> sum = metrics.getHistogram();
        double created = (double)metrics.getCreatedMillis() * 0.001;
        for (Map.Entry<Double, Integer> e : sum.entrySet()) {
            w.append(id + "_bucket{le=\"" + OpenMetricsFormatter.formatNumber(e.getKey()) + "\"} " + String.valueOf(e.getValue()) + "\n");
        }
        w.append(id + "_created " + OpenMetricsFormatter.formatNumber(created) + "\n");
    }

    public static void formatMetrics(Appendable w, IActiveMetrics<?> metrics) throws IOException {
        OpenMetricsType type = metrics.getOpenMetricsType();
        String id = OpenMetricsFormatter.quote(metrics.getTaggedMetrics().getId());
        w.append("# TYPE " + id + " " + String.valueOf((Object)type) + "\n");
        switch (type) {
            case counter: {
                OpenMetricsFormatter.formatCounter(w, id, metrics);
                break;
            }
            case gauge: {
                OpenMetricsFormatter.formatGauge(w, id, metrics);
                break;
            }
            case histogram: {
                OpenMetricsFormatter.formatHistogram(w, id, metrics);
                break;
            }
            case summary: {
                OpenMetricsFormatter.formatSummary(w, id, metrics);
            }
        }
    }
}

