/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring.health;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthInfoWithLog;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.clazzes.svc.runner.monitoring.IActiveMetrics;
import org.clazzes.svc.runner.monitoring.IActiveMonitoring;
import org.clazzes.svc.runner.monitoring.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemHealthServlet
extends HttpServlet {
    private static final String NO_RESULT_YET = "No result yet...";
    private static final Logger log = LoggerFactory.getLogger(SystemHealthServlet.class);
    private final IActiveMonitoring monitoring;
    private static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";
    private static final String CSS = "body { font-size:12px; font-family:arial,verdana,sans-serif; }\nh1 { font-size:20px;}\ntable { font-size:12px; border:#ccc 1px solid; border-radius:3px; }\ntable th { padding:5px; text-align: left; background: #ededed; }\ntable td { padding:5px; border-top: 1px solid #ffffff; border-bottom:1px solid #e0e0e0; border-left: 1px solid #e0e0e0; }\n.statusOK { background-color:#CCFFCC;}\n.statusWARN { background-color:#FFE569;}\n.statusCRITICAL { background-color:#F0975A;}\n.statusHEALTH_CHECK_ERROR { background-color:#F16D4E;}\n.statusnull { background-color:#CCCCCC;}\n.helpText { color:grey; font-size:80%; }\n.collapsible span::before { content: \"\u25bc\"; }\n.collapsible.collapsed span::before { content: \"\u25b6\"; }\n.collapsed div { display: none; }\n";
    private static final String SCRIPT = "var tc=function(event){\nif(event.type!=\"keydown\"||event.keyCode==13||event.keyCode==32){\n  this.classList.toggle('collapsed');\n}};\ndocument.addEventListener(\"DOMContentLoaded\",function(){\n  var elements = document.getElementsByClassName(\"collapsible\");\n  for (var i=0;i!=elements.length;++i) {\n    var e = elements[i];\n    e.setAttribute(\"tabindex\",0);\n    e.addEventListener('keydown',tc.bind(e),false);\n    e.addEventListener('click',tc.bind(e),false);\n  }\n});\n";
    private static final String HELP_ID = "health check ID to select - can also be specified multiple times like /system/health?id=system.memory&id=jdbc.MYDB\n";
    private static final String HELP_TAG = "health check tag to select - can also be specified multiple times like /system/health?tag=system&tag=jdbc\n";
    private static final String HELP_FORMAT = "Output format, html|json|yaml - The default format is deduced from the Accept HTTP-Header\n";
    private static final DateTimeFormatter HTML_DTF = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final DateTimeFormatter JSON_DTF = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSZ");
    private static final NumberFormat DURATION_FORMAT = NumberFormat.getInstance(Locale.ENGLISH);
    private static final XMLOutputFactory XOF = XMLOutputFactory.newDefaultFactory();

    public SystemHealthServlet(IActiveMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    private static final void setNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "0");
    }

    private static final void writeString(XMLStreamWriter xsw, String s) throws XMLStreamException {
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                xsw.writeEmptyElement("br");
            }
            xsw.writeCharacters(lines[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatHTML(HttpServletResponse resp, SortedMap<String, IActiveMetrics<HealthInfo>> selectedMetrics, Map<String, Result<HealthInfo>> results, HealthStatus overall) throws Exception {
        ServletOutputStream os = resp.getOutputStream();
        resp.setHeader("X-Frame-Options", "SAMEORIGIN");
        resp.setHeader("Content-Language", "en");
        resp.setContentType("text/html; charset=utf-8");
        os.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n".getBytes("UTF-8"));
        try (XMLStreamWriter xsw = XOF.createXMLStreamWriter((OutputStream)os);){
            xsw.setDefaultNamespace(XHTML_NS_URI);
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace(XHTML_NS_URI);
            xsw.writeAttribute("lang", "en");
            xsw.writeAttribute("xml:lang", "en");
            xsw.writeStartElement("head");
            xsw.writeEmptyElement("meta");
            xsw.writeAttribute("http-equiv", "Content-Type");
            xsw.writeAttribute("content", "text/html; charset=utf-8");
            xsw.writeStartElement("style");
            xsw.writeCharacters(CSS);
            xsw.writeEndElement();
            xsw.writeStartElement("script");
            xsw.writeCharacters(SCRIPT);
            xsw.writeEndElement();
            xsw.writeStartElement("title");
            xsw.writeCharacters("System Health");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("h1");
            xsw.writeCharacters("System Health");
            xsw.writeEndElement();
            xsw.writeStartElement("p");
            xsw.writeStartElement("span");
            xsw.writeAttribute("class", "status" + String.valueOf(overall));
            xsw.writeAttribute("style", "padding:4px");
            xsw.writeStartElement("strong");
            xsw.writeCharacters("Overall Result: " + String.valueOf(overall));
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("table");
            xsw.writeAttribute("id", "healthCheckResults");
            xsw.writeAttribute("cellspacing", "0");
            xsw.writeStartElement("thead");
            xsw.writeStartElement("tr");
            xsw.writeStartElement("th");
            xsw.writeCharacters("Health Check ");
            xsw.writeStartElement("span");
            xsw.writeAttribute("style", "color:gray");
            xsw.writeCharacters("(tags)");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("Status");
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("Log");
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("Finished At");
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("Time");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("tbody");
            for (Map.Entry<String, IActiveMetrics<HealthInfo>> e : selectedMetrics.entrySet()) {
                HealthStatus status;
                String id = e.getKey();
                Result<HealthInfo> r = results.get(id);
                HealthStatus healthStatus = status = r == null ? null : r.getResult().getStatus();
                if (status == null) {
                    status = HealthStatus.HEALTH_CHECK_ERROR;
                }
                xsw.writeStartElement("tr");
                xsw.writeAttribute("class", "status" + String.valueOf(status));
                xsw.writeStartElement("td");
                xsw.writeAttribute("title", e.getValue().getTaggedMetrics().getDescription());
                xsw.writeCharacters(id);
                xsw.writeEmptyElement("br");
                xsw.writeStartElement("span");
                xsw.writeAttribute("style", "color:gray");
                List tags = e.getValue().getTaggedMetrics().getTags();
                if (tags != null) {
                    xsw.writeCharacters(String.join((CharSequence)", ", tags));
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeStartElement("td");
                xsw.writeAttribute("style", "font-weight:bold");
                xsw.writeCharacters(status.toString());
                xsw.writeEndElement();
                xsw.writeStartElement("td");
                if (r == null) {
                    xsw.writeCharacters(NO_RESULT_YET);
                } else {
                    HealthInfo result = r.getResult();
                    if (result instanceof HealthInfoWithLog) {
                        HealthInfoWithLog hil = (HealthInfoWithLog)result;
                        xsw.writeAttribute("class", "collapsible collapsed");
                        xsw.writeStartElement("span");
                        SystemHealthServlet.writeString(xsw, result.getExplanation());
                        xsw.writeEndElement();
                        for (HealthInfo hi : hil.getLog()) {
                            xsw.writeStartElement("div");
                            xsw.writeStartElement("b");
                            xsw.writeCharacters(hi.getStatus().toString());
                            xsw.writeEndElement();
                            xsw.writeCharacters("\u00a0");
                            SystemHealthServlet.writeString(xsw, hi.getExplanation());
                            xsw.writeEndElement();
                        }
                    } else {
                        SystemHealthServlet.writeString(xsw, result.getExplanation());
                    }
                }
                xsw.writeEndElement();
                ZonedDateTime dt = r == null ? ZonedDateTime.now() : ZonedDateTime.ofInstant(Instant.ofEpochMilli(r.getEpochMillis()), ZoneId.systemDefault());
                xsw.writeStartElement("td");
                xsw.writeCharacters(HTML_DTF.format(dt));
                xsw.writeEndElement();
                Long duration = r == null ? null : r.getNanosDuration();
                xsw.writeStartElement("td");
                if (duration != null) {
                    xsw.writeCharacters(DURATION_FORMAT.format((double)duration.longValue() * 1.0E-6) + "ms");
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("div");
            xsw.writeAttribute("class", "helpText");
            xsw.writeStartElement("h3");
            xsw.writeCharacters("Supported URL parameters");
            xsw.writeEndElement();
            xsw.writeStartElement("b");
            xsw.writeCharacters("id");
            xsw.writeEndElement();
            xsw.writeCharacters(" ");
            xsw.writeCharacters(HELP_ID);
            xsw.writeEmptyElement("br");
            xsw.writeStartElement("b");
            xsw.writeCharacters("tag");
            xsw.writeEndElement();
            xsw.writeCharacters(" ");
            xsw.writeCharacters(HELP_TAG);
            xsw.writeEmptyElement("br");
            xsw.writeStartElement("b");
            xsw.writeCharacters("format");
            xsw.writeEndElement();
            xsw.writeCharacters(" ");
            xsw.writeCharacters(HELP_FORMAT);
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
    }

    protected void formatJackson(JsonGenerator w, SortedMap<String, IActiveMetrics<HealthInfo>> selectedMetrics, Map<String, Result<HealthInfo>> results, HealthStatus overall) throws Exception {
        w.writeStartObject();
        w.writeFieldName("overallResult");
        if (overall == null) {
            w.writeNull();
        } else {
            w.writeString(overall.toString());
        }
        w.writeFieldName("results");
        w.writeStartArray();
        for (Map.Entry<String, IActiveMetrics<HealthInfo>> e : selectedMetrics.entrySet()) {
            String expl;
            List tags;
            HealthStatus status;
            String id = e.getKey();
            Result<HealthInfo> r = results.get(id);
            HealthStatus healthStatus = status = r == null ? null : r.getResult().getStatus();
            if (status == null) {
                status = HealthStatus.HEALTH_CHECK_ERROR;
            }
            w.writeStartObject();
            w.writeStringField("id", id);
            w.writeStringField("status", status.toString());
            ZonedDateTime dt = r == null ? ZonedDateTime.now() : ZonedDateTime.ofInstant(Instant.ofEpochMilli(r.getEpochMillis()), ZoneId.systemDefault());
            w.writeStringField("finishedAt", JSON_DTF.format(dt));
            if (r != null && r.getNanosDuration() != null) {
                w.writeNumberField("timeInMs", (double)r.getNanosDuration().longValue() * 1.0E-6);
            }
            if ((tags = e.getValue().getTaggedMetrics().getTags()) != null) {
                w.writeFieldName("tags");
                w.writeStartArray();
                for (String tag : tags) {
                    w.writeString(tag);
                }
                w.writeEndArray();
            }
            w.writeFieldName("messages");
            w.writeStartArray();
            w.writeStartObject();
            w.writeStringField("status", status.toString());
            String string = expl = r == null ? NO_RESULT_YET : r.getResult().getExplanation();
            if (expl != null) {
                w.writeStringField("message", expl);
            }
            w.writeEndObject();
            w.writeEndArray();
            w.writeEndObject();
        }
        w.writeEndArray();
        w.writeEndObject();
    }

    protected void formatJson(HttpServletResponse resp, SortedMap<String, IActiveMetrics<HealthInfo>> selectedMetrics, Map<String, Result<HealthInfo>> results, HealthStatus overall) throws Exception {
        resp.setContentType("application/json");
        JsonFactory jf = JsonFactory.builder().build();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "utf-8");){
            JsonGenerator gen = jf.createGenerator((Writer)osw);
            this.formatJackson(gen, selectedMetrics, results, overall);
            gen.flush();
        }
    }

    protected void formatYaml(HttpServletResponse resp, SortedMap<String, IActiveMetrics<HealthInfo>> selectedMetrics, Map<String, Result<HealthInfo>> results, HealthStatus overall) throws Exception {
        resp.setContentType("application/yaml");
        YAMLFactory yf = YAMLFactory.builder().build();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "utf-8");){
            YAMLGenerator gen = yf.createGenerator((Writer)osw);
            this.formatJackson((JsonGenerator)gen, selectedMetrics, results, overall);
            gen.flush();
        }
    }

    protected void formatPlainText(HttpServletResponse resp, HealthStatus overall) throws Exception {
        resp.setContentType("text/plain;charset=utf-8");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "utf-8");){
            osw.write(String.valueOf(overall));
            osw.write(10);
        }
    }

    protected static final HealthStatus aggregate(HealthStatus a, HealthStatus b) {
        if (a == null) {
            return b;
        }
        if (b == null || b == HealthStatus.HEALTH_CHECK_ERROR) {
            return HealthStatus.HEALTH_CHECK_ERROR;
        }
        return b.getValue() < a.getValue() ? b : a;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int responseCode;
        String accept;
        String[] ids = req.getParameterValues("id");
        String[] tags = req.getParameterValues("tag");
        String format = req.getParameter("format");
        if (format == null && (accept = req.getHeader("Accept")) != null) {
            if ("application/json".equals(accept)) {
                format = "json";
            } else if ("application/yaml".equals(accept)) {
                format = "yaml";
            } else if ("text/plain".equals(accept) || accept.startsWith("text/plain,") || accept.startsWith("text/plain;")) {
                format = "txt";
            } else if ("text/html".equals(accept) || accept.startsWith("text/html,") || accept.startsWith("text/html;") || "*/*".equals(accept)) {
                format = "html";
            } else {
                log.warn("Unparseable Accept header [{}], assuming text/html", (Object)accept);
            }
        }
        TreeMap<String, IActiveMetrics<HealthInfo>> selectedMetrics = new TreeMap<String, IActiveMetrics<HealthInfo>>();
        if (ids == null && tags == null) {
            selectedMetrics.putAll(this.monitoring.getHealthChecks());
        } else {
            if (ids != null) {
                for (String id : ids) {
                    IActiveMetrics<HealthInfo> hc = this.monitoring.getHealthCheck(id);
                    if (hc == null) continue;
                    selectedMetrics.put(id, hc);
                }
            }
            if (tags != null) {
                for (String tag : tags) {
                    for (IActiveMetrics iActiveMetrics : this.monitoring.getByTag(tag)) {
                        if (!(iActiveMetrics.getTaggedMetrics() instanceof HealthCheck)) continue;
                        selectedMetrics.put(iActiveMetrics.getTaggedMetrics().getId(), iActiveMetrics);
                    }
                }
            }
        }
        HashMap<String, Result<HealthInfo>> results = new HashMap<String, Result<HealthInfo>>();
        HealthStatus overall = null;
        for (Map.Entry e : selectedMetrics.entrySet()) {
            Result r = ((IActiveMetrics)e.getValue()).getResult();
            results.put((String)e.getKey(), r);
            overall = SystemHealthServlet.aggregate(overall, r == null ? HealthStatus.HEALTH_CHECK_ERROR : ((HealthInfo)r.getResult()).getStatus());
        }
        if (overall == null) {
            responseCode = 500;
        } else {
            switch (overall) {
                case OK: 
                case WARN: {
                    responseCode = 200;
                    break;
                }
                case CRITICAL: {
                    responseCode = 503;
                    break;
                }
                default: {
                    responseCode = 500;
                }
            }
        }
        resp.setStatus(responseCode);
        SystemHealthServlet.setNoCacheHeaders(resp);
        try {
            if ("yaml".equals(format)) {
                this.formatYaml(resp, selectedMetrics, results, overall);
            } else if ("json".equals(format)) {
                this.formatJson(resp, selectedMetrics, results, overall);
            } else if ("txt".equals(format)) {
                this.formatPlainText(resp, overall);
            } else {
                this.formatHTML(resp, selectedMetrics, results, overall);
            }
        }
        catch (Exception e) {
            log.error("Error formatting Health Checks", (Throwable)e);
            throw new ServletException("Cannot format health checks");
        }
    }

    static {
        DURATION_FORMAT.setMinimumFractionDigits(1);
        DURATION_FORMAT.setMaximumFractionDigits(1);
    }
}

