/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.clazzes.svc.runner.monitoring.Result;

public class ResultHistory<T extends Comparable<T>> {
    private final long retentionNanons;
    private final Function<Double, Result<T>> doubleFactory;
    private SortedMap<Long, Result<T>> resultsByNanoTime;
    private SortedSet<Result<T>> resultsByValue;

    public ResultHistory(long retentionNanons, Function<Double, Result<T>> doubleFactory) {
        this.retentionNanons = retentionNanons;
        this.doubleFactory = doubleFactory;
        this.resultsByNanoTime = new TreeMap<Long, Result<T>>();
        this.resultsByValue = new TreeSet<Result<T>>();
    }

    public synchronized void putResult(Result<T> r) {
        long watermark = r.getNanoTime() - this.retentionNanons;
        SortedMap<Long, Result<T>> head = this.resultsByNanoTime.headMap(watermark);
        this.resultsByValue.removeAll(head.values());
        head.clear();
        this.resultsByNanoTime.put(r.getNanoTime(), r);
        if (r.isValid()) {
            this.resultsByValue.add(r);
        }
    }

    public synchronized List<Result<T>> getHistory() {
        return new ArrayList<Result<T>>(this.resultsByNanoTime.values());
    }

    public synchronized SortedMap<Double, Integer> getHistogram(double[] leValues) {
        TreeMap<Double, Integer> ret = new TreeMap<Double, Integer>();
        for (double le : leValues) {
            ret.put(le, this.resultsByValue.headSet(this.doubleFactory.apply(le)).size());
        }
        ret.put(Double.POSITIVE_INFINITY, this.resultsByValue.size());
        return ret;
    }

    public synchronized SortedMap<Double, Number> getSummary(double[] quantiles) {
        TreeMap<Double, Number> ret = new TreeMap<Double, Number>();
        if (quantiles == null || quantiles.length <= 0) {
            throw new IllegalArgumentException("Wee need to caclulate at least one quantile.");
        }
        int iq = 0;
        int ir = 0;
        double q = quantiles[iq];
        double nri = 1.0 / ((double)this.resultsByValue.size() - 1.0);
        for (Result result : this.resultsByValue) {
            if (nri * (double)ir > q) {
                ret.put(q, result.getNumericResult());
                if (++iq >= quantiles.length) break;
                q = quantiles[iq];
            }
            ++ir;
        }
        return ret;
    }
}

