/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.clazzes.svc.api.monitoring.Counter;
import org.clazzes.svc.api.monitoring.Gauge;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.runner.monitoring.IActiveMetrics;
import org.clazzes.svc.runner.monitoring.IActiveMonitoring;
import org.clazzes.svc.runner.monitoring.MetricsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringEngine
implements IActiveMonitoring {
    private static final Logger log = LoggerFactory.getLogger(MonitoringEngine.class);
    private final ScheduledExecutorService executorService;
    private final int keepResultsSeconds;
    private final ConcurrentHashMap<String, MetricsHolder<HealthInfo>> healthChecks;
    private final ConcurrentHashMap<String, MetricsHolder<Long>> counters;
    private final ConcurrentHashMap<String, MetricsHolder<Double>> gauges;
    private final ConcurrentHashMap<String, List<IActiveMetrics<?>>> tags;

    public MonitoringEngine(ScheduledExecutorService executorService, int keepResultsSeconds) {
        this.executorService = executorService;
        this.keepResultsSeconds = keepResultsSeconds;
        this.healthChecks = new ConcurrentHashMap();
        this.counters = new ConcurrentHashMap();
        this.gauges = new ConcurrentHashMap();
        this.tags = new ConcurrentHashMap();
    }

    public void addToTags(IActiveMetrics<?> am) {
        List myTags = am.getTaggedMetrics().getTags();
        if (myTags != null) {
            for (String tag : myTags) {
                this.tags.putIfAbsent(tag, new CopyOnWriteArrayList());
                List<IActiveMetrics<?>> tagMetrics = this.tags.get(tag);
                tagMetrics.add(am);
            }
        }
    }

    public void removeFromTags(IActiveMetrics<?> am) {
        List myTags = am.getTaggedMetrics().getTags();
        if (myTags != null) {
            for (String tag : myTags) {
                List tagMetrics = this.tags.putIfAbsent(tag, new CopyOnWriteArrayList());
                tagMetrics.add(am);
            }
        }
    }

    public void addHealthCheck(String key, HealthCheck healthCheck) {
        MetricsHolder<HealthInfo> old;
        log.info("Registering HealthCheck [{}] for key [{}].", (Object)healthCheck.getClass().getName(), (Object)key);
        MetricsHolder<HealthInfo> holder = MetricsHolder.ofHealthCheck(healthCheck, this.keepResultsSeconds);
        if (holder.schedule(this.executorService)) {
            log.info("Successfully started async HealthCheck [{}] for key [{}].", (Object)healthCheck.getClass().getName(), (Object)key);
        }
        if ((old = this.healthChecks.put(key, holder)) != null) {
            log.warn("Overwriting old HealthCheck [{}] for key [{}].", (Object)old.getClass().getName(), (Object)key);
            old.shutdown();
        }
        this.addToTags(holder);
    }

    public void removeHealthCheck(String key) {
        MetricsHolder<HealthInfo> holder = this.healthChecks.remove(key);
        if (holder != null) {
            log.warn("Removing HealthCheck [{}] for key [{}].", (Object)holder.getTaggedMetrics().getClass().getName(), (Object)key);
            holder.shutdown();
            this.removeFromTags(holder);
        } else {
            log.warn("No HealthCheck to remove for key [{}].", (Object)key);
        }
    }

    @Override
    public Map<String, IActiveMetrics<HealthInfo>> getHealthChecks() {
        return new HashMap<String, IActiveMetrics<HealthInfo>>(this.healthChecks);
    }

    @Override
    public IActiveMetrics<HealthInfo> getHealthCheck(String key) {
        return this.healthChecks.get(key);
    }

    public void addCounter(String key, Counter counter) {
        MetricsHolder<Long> old;
        log.info("Registering Counter [{}] for key [{}].", (Object)counter.getClass().getName(), (Object)key);
        MetricsHolder<Long> holder = MetricsHolder.ofCounter(counter, this.keepResultsSeconds);
        if (holder.schedule(this.executorService)) {
            log.info("Successfully started async Counter [{}] for key [{}].", (Object)counter.getClass().getName(), (Object)key);
        }
        if ((old = this.counters.put(key, holder)) != null) {
            log.warn("Overwriting old Counter [{}] for key [{}].", (Object)old.getClass().getName(), (Object)key);
            old.shutdown();
        }
        this.addToTags(holder);
    }

    public void removeCounter(String key) {
        MetricsHolder<Long> holder = this.counters.remove(key);
        if (holder != null) {
            log.warn("Removing Counter [{}] for key [{}].", (Object)holder.getTaggedMetrics().getClass().getName(), (Object)key);
            holder.shutdown();
            this.removeFromTags(holder);
        } else {
            log.warn("No Counter to remove for key [{}].", (Object)key);
        }
    }

    @Override
    public Map<String, IActiveMetrics<Long>> getCounters() {
        return new HashMap<String, IActiveMetrics<Long>>(this.counters);
    }

    @Override
    public IActiveMetrics<Long> getCounter(String key) {
        return this.counters.get(key);
    }

    public void addGauge(String key, Gauge gauge) {
        MetricsHolder<Double> old;
        log.info("Registering Gauge [{}] for key [{}].", (Object)gauge.getClass().getName(), (Object)key);
        MetricsHolder<Double> holder = MetricsHolder.ofGauge(gauge, this.keepResultsSeconds);
        if (holder.schedule(this.executorService)) {
            log.info("Successfully started async Gauge [{}] for key [{}].", (Object)gauge.getClass().getName(), (Object)key);
        }
        if ((old = this.gauges.put(key, holder)) != null) {
            log.warn("Overwriting old Gauge [{}] for key [{}].", (Object)old.getClass().getName(), (Object)key);
            old.shutdown();
        }
        this.addToTags(holder);
    }

    public void removeGauge(String key) {
        MetricsHolder<Double> holder = this.gauges.remove(key);
        if (holder != null) {
            log.warn("Removing Gauge [{}] for key [{}].", (Object)holder.getTaggedMetrics().getClass().getName(), (Object)key);
            holder.shutdown();
            this.removeFromTags(holder);
        } else {
            log.warn("No Gauge to remove for key [{}].", (Object)key);
        }
    }

    @Override
    public Map<String, IActiveMetrics<Double>> getGauges() {
        return new HashMap<String, IActiveMetrics<Double>>(this.gauges);
    }

    @Override
    public IActiveMetrics<Double> getGauge(String key) {
        return this.gauges.get(key);
    }

    @Override
    public List<IActiveMetrics<?>> getByTag(String tag) {
        List<IActiveMetrics<Object>> ret = this.tags.get(tag);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    @Override
    public Optional<IActiveMetrics<?>> getById(String id) {
        IActiveMetrics ret = this.healthChecks.get(id);
        if (ret != null) {
            return Optional.of(ret);
        }
        ret = this.counters.get(id);
        if (ret != null) {
            return Optional.of(ret);
        }
        ret = this.gauges.get(id);
        if (ret != null) {
            return Optional.of(ret);
        }
        return Optional.empty();
    }
}

