/***********************************************************
*
* Service Runner of the clazzes.org project
* https://www.clazzes.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
***********************************************************/

package org.clazzes.svc.runner.jdbc;

import java.sql.SQLException;

import org.clazzes.svc.api.ConfigWrapper;

import com.zaxxer.hikari.HikariDataSource;

public abstract class DataSourceHelper {

    static HikariDataSource createDataSource(ConfigWrapper config) throws SQLException {

        HikariDataSource ds = new HikariDataSource();

        ds.setJdbcUrl(config.getMandatoryString("url"));

        String username = config.getString("username");
        if (username != null) {
            ds.setUsername(username);
        }

        String passwd = config.getString("password");
        if (passwd != null) {
            ds.setPassword(passwd);
        }

        String validationQuery = config.getString("validationQuery");
        if (validationQuery != null) {
            ds.setConnectionTestQuery(validationQuery);
        }

        Long maxConnLifetimeMillis = config.getLong("maxConnLifetimeMillis");

        if (maxConnLifetimeMillis != null) {
            ds.setMaxLifetime(maxConnLifetimeMillis);
        }

        Integer maxTotal = config.getInteger("maxTotal");

        if (maxTotal != null) {
            ds.setMaximumPoolSize(maxTotal);
        }

        Integer minIdle = config.getInteger("minIdle");

        if (minIdle != null) {
            ds.setMinimumIdle(minIdle);
        }

        Long idleTimeout = config.getLong("idleTimeout");

        if (idleTimeout != null) {
            ds.setIdleTimeout(idleTimeout);
        }

        Long connectionTimeout = config.getLong("connectionTimeout");

        if (connectionTimeout != null) {
            ds.setConnectionTimeout(connectionTimeout);
        }

        Long validationTimeout = config.getLong("validationTimeout");

        if (validationTimeout != null) {
            ds.setValidationTimeout(validationTimeout);
        }

        Integer loginTimeout = config.getInteger("loginTimeout");

        if (loginTimeout != null) {
            ds.setLoginTimeout(loginTimeout);
        }

        String defaultCatalog = config.getString("defaultCatalog");

        if (defaultCatalog != null) {
            ds.setCatalog(defaultCatalog);
        }

        String defaultSchema = config.getString("defaultSchema");

        if (defaultSchema != null) {
            ds.setSchema(defaultSchema);
        }

        Boolean defaultReadOnly = config.getBoolean("defaultReadOnly");

        if (defaultReadOnly != null) {
            ds.setReadOnly(defaultReadOnly);
        }

        Boolean defaultAutoCommit = config.getBoolean("defaultAutoCommit");

        if (defaultAutoCommit != null) {
            ds.setAutoCommit(defaultAutoCommit);
        }

        String defaultTransactionIsolation = config.getString("defaultTransactionIsolation");

        if (defaultTransactionIsolation != null) {
            ds.setTransactionIsolation(defaultTransactionIsolation);
        }

        return ds;
    }

}
