/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceInfo;
import org.clazzes.svc.api.ServiceKey;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.ThrowableInfo;
import org.clazzes.svc.runner.HasContext;
import org.clazzes.svc.runner.ThrowableBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryImpl
extends HasContext
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final InstanceMap registry = new InstanceMap();
    private final ConcurrentHashMap<Class<?>, List<ClassListeners<?>>> classListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<ServiceKey<?>, List<InstanceListeners<?>>> instanceListeners = new ConcurrentHashMap();

    public void start(ServiceContext svcCtxt) {
        this.setContext(svcCtxt);
    }

    public void stop() {
        this.clearContext();
    }

    private <T> void callClassListener(ServiceKey<T> ikey, ServiceHolder<T> service, String label, BiConsumer<String, T> listener) {
        this.getContext().scheduleManipulator(() -> {
            try {
                log.info("Calling '{}' class listener [{}] on {}", new Object[]{label, listener, ikey});
                listener.accept(ikey.getKey(), service.getService());
            }
            catch (Throwable e) {
                ThrowableInfo ti = service.error(log, "Error calling '{}' class listener [{}] on {}", label, listener, ikey, e);
                this.getContext().getService(ComponentManager.class).ifPresent(cm -> cm.recordServiceException(ti));
            }
        });
    }

    private <T> void callInstanceListener(ServiceKey<T> ikey, ServiceHolder<T> service, String label, Consumer<T> listener) {
        this.getContext().scheduleManipulator(() -> {
            try {
                log.info("Calling '{}' listener [{}] on {}", new Object[]{label, listener, ikey});
                listener.accept(service.getService());
            }
            catch (Throwable e) {
                ThrowableInfo ti = service.error(log, "Error calling '{}' listener [{}] on {}", label, listener, ikey, e);
                this.getContext().getService(ComponentManager.class).ifPresent(cm -> cm.recordServiceException(ti));
            }
        });
    }

    private <T> List<InstanceListeners<?>> getInstanceListeners(ServiceKey<T> ikey) {
        return this.instanceListeners.computeIfAbsent(ikey, k -> new ArrayList());
    }

    private <T> List<ClassListeners<?>> getClassListeners(Class<T> iface) {
        return this.classListeners.computeIfAbsent(iface, k -> new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addService(String key, Class<T> iface, T service) {
        ServiceKey ikey = new ServiceKey(key, iface);
        Map<String, ServiceHolder<T>> iregistry = this.registry.getOrCreate(iface);
        if (iregistry.containsKey(key)) {
            throw new IllegalStateException("Duplicate " + String.valueOf(ikey) + " is already registered.");
        }
        List<InstanceListeners<?>> ils = this.getInstanceListeners(ikey);
        List<ClassListeners<?>> cls = this.getClassListeners(iface);
        ServiceRegistryImpl serviceRegistryImpl = this;
        synchronized (serviceRegistryImpl) {
            ServiceHolder<T> h = new ServiceHolder<T>(service);
            iregistry.put(key, h);
            log.info("Registered " + String.valueOf(ikey));
            Iterator<Object> iterator = ils.iterator();
            while (iterator.hasNext()) {
                InstanceListeners<?> il;
                InstanceListeners<?> til = il = iterator.next();
                this.callInstanceListener(ikey, h, "added", til.added);
            }
            iterator = cls.iterator();
            while (iterator.hasNext()) {
                ClassListeners cl;
                ClassListeners tcl = cl = (ClassListeners)iterator.next();
                this.callClassListener(ikey, h, "added", tcl.added);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeService(String key, Class<T> iface) {
        ServiceKey ikey = new ServiceKey(key, iface);
        Map<String, ServiceHolder<T>> iregistry = this.registry.get(iface);
        if (iregistry == null) {
            log.warn("No service has been registered for interface [" + String.valueOf(iface) + "], will not call remove listeners.");
            return false;
        }
        List<InstanceListeners<?>> ils = this.getInstanceListeners(ikey);
        List<ClassListeners<?>> cls = this.getClassListeners(iface);
        ServiceRegistryImpl serviceRegistryImpl = this;
        synchronized (serviceRegistryImpl) {
            ServiceHolder<T> service = iregistry.remove(key);
            if (service == null) {
                log.warn(String.valueOf(ikey) + " is not registered, will not call remove listeners.");
                return false;
            }
            log.info("Unregistered " + String.valueOf(ikey));
            Iterator<Object> iterator = ils.iterator();
            while (iterator.hasNext()) {
                InstanceListeners<?> il;
                InstanceListeners<?> til = il = iterator.next();
                this.callInstanceListener(ikey, service, "removed", til.removed);
            }
            iterator = cls.iterator();
            while (iterator.hasNext()) {
                ClassListeners cl;
                ClassListeners tcl = cl = (ClassListeners)iterator.next();
                this.callClassListener(ikey, service, "removed", tcl.removed);
            }
        }
        return true;
    }

    public <T> Optional<T> getService(String key, Class<T> iface) {
        ServiceHolder<T> instance;
        Map<String, ServiceHolder<T>> instances = this.registry.get(iface);
        if (instances != null && (instance = instances.get(key)) != null) {
            return Optional.of(instance.getService());
        }
        return Optional.empty();
    }

    protected <T> Optional<ServiceHolder<T>> getServiceHolder(String key, Class<T> iface) {
        ServiceHolder<T> instance;
        Map<String, ServiceHolder<T>> instances = this.registry.get(iface);
        if (instances != null && (instance = instances.get(key)) != null) {
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public <T> Map<String, T> getAll(Class<T> iface) {
        Map<String, ServiceHolder<T>> instances = this.registry.get(iface);
        if (instances == null) {
            return Collections.emptyMap();
        }
        HashMap ret = new HashMap(instances.size());
        instances.entrySet().forEach(e -> ret.put((String)e.getKey(), ((ServiceHolder)e.getValue()).getService()));
        return ret;
    }

    protected <T> Map<String, ServiceHolder<T>> getAllHolders(Class<T> iface) {
        Map<String, ServiceHolder<T>> instances = this.registry.get(iface);
        if (instances == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, ServiceHolder<T>>(instances);
    }

    public <T> Optional<T> getAny(Class<T> iface) {
        Iterator<ServiceHolder<T>> it;
        Map<String, ServiceHolder<T>> instances = this.registry.get(iface);
        if (instances != null && (it = instances.values().iterator()).hasNext()) {
            return Optional.of(it.next().getService());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> AutoCloseable listen(String key, Class<T> iface, Consumer<T> added, Consumer<T> removed) {
        ServiceKey ikey = new ServiceKey(key, iface);
        List<InstanceListeners<?>> ils = this.getInstanceListeners(ikey);
        InstanceListeners listeners = new InstanceListeners(added, removed);
        ServiceRegistryImpl serviceRegistryImpl = this;
        synchronized (serviceRegistryImpl) {
            this.getServiceHolder(key, iface).ifPresent(service -> this.callInstanceListener((ServiceKey)ikey, (ServiceHolder)service, "added", added));
            ils.add(listeners);
        }
        return () -> {
            ServiceRegistryImpl serviceRegistryImpl = this;
            synchronized (serviceRegistryImpl) {
                ils.remove(listeners);
                this.getServiceHolder(key, iface).ifPresent(service -> this.callInstanceListener((ServiceKey)ikey, (ServiceHolder)service, "removed", removed));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> AutoCloseable listenAll(Class<T> iface, BiConsumer<String, T> added, BiConsumer<String, T> removed) {
        List<ClassListeners<?>> cls = this.getClassListeners(iface);
        ClassListeners listeners = new ClassListeners(added, removed);
        ServiceRegistryImpl serviceRegistryImpl = this;
        synchronized (serviceRegistryImpl) {
            this.getAllHolders(iface).forEach((key, service) -> {
                ServiceKey ikey = new ServiceKey(key, iface);
                this.callClassListener((ServiceKey)ikey, (ServiceHolder)service, "added", added);
            });
            cls.add(listeners);
        }
        return () -> {
            ServiceRegistryImpl serviceRegistryImpl = this;
            synchronized (serviceRegistryImpl) {
                cls.remove(listeners);
                this.getAllHolders(iface).forEach((key, service) -> {
                    ServiceKey ikey = new ServiceKey(key, iface);
                    this.callClassListener((ServiceKey)ikey, (ServiceHolder)service, "removed", removed);
                });
            }
        };
    }

    public List<ServiceInfo> listServices() {
        return this.listServices(null);
    }

    protected final <T> void appendServiceInfos(List<ServiceInfo> services, Class<T> key) {
        Map<String, ServiceHolder<T>> instances = this.registry.get(key);
        for (Map.Entry<String, ServiceHolder<T>> ee : instances.entrySet()) {
            T target = ee.getValue().getService();
            String implementation = Proxy.isProxyClass(target.getClass()) ? Proxy.getInvocationHandler(target).toString() : target.getClass().getName();
            services.add(new ServiceInfo(key.getName(), ee.getKey(), implementation, ee.getValue().getThrowables()));
        }
    }

    public List<ServiceInfo> listServices(String iface) {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>(256);
        for (Class<?> key : this.registry.keySet()) {
            if (iface != null && !iface.equals(key.getName())) continue;
            this.appendServiceInfos(services, key);
        }
        Collections.sort(services);
        return services;
    }

    private static final class InstanceMap {
        private final Map<Class<?>, Map<String, ?>> map = new ConcurrentHashMap();

        public Set<Class<?>> keySet() {
            return this.map.keySet();
        }

        public <T> Map<String, ServiceHolder<T>> get(Class<T> iface) {
            return this.map.get(iface);
        }

        public <T> Map<String, ServiceHolder<T>> getOrCreate(Class<T> iface) {
            return this.map.computeIfAbsent(iface, k -> new ConcurrentHashMap());
        }
    }

    private static final class ServiceHolder<T>
    extends ThrowableBucket {
        private final T service;

        public ServiceHolder(T service) {
            this.service = service;
        }

        public T getService() {
            return this.service;
        }
    }

    private static final class InstanceListeners<T> {
        public final Consumer<T> added;
        public final Consumer<T> removed;

        public InstanceListeners(Consumer<T> added, Consumer<T> removed) {
            this.added = added;
            this.removed = removed;
        }
    }

    private static final class ClassListeners<T> {
        public final BiConsumer<String, T> added;
        public final BiConsumer<String, T> removed;

        public ClassListeners(BiConsumer<String, T> added, BiConsumer<String, T> removed) {
            this.added = added;
            this.removed = removed;
        }
    }
}

