/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.util.function.Supplier;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.runner.CoreServiceImpl;

public class SecretSupplier
implements Supplier<String> {
    private final String pid;
    private final String scheme;
    private final String key;

    public SecretSupplier(String pid, String scheme, String key) {
        this.pid = pid;
        this.scheme = scheme;
        this.key = key;
    }

    @Override
    public String get() {
        CoreService coreService = CoreServiceImpl.provider();
        return coreService.getSecret(this.pid, this.scheme, this.key);
    }

    public String getPid() {
        return this.pid;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "SecretSupplier[" + this.scheme + ":" + this.key + "(" + this.pid + ")]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecretSupplier other = (SecretSupplier)obj;
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

