/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.clazzes.svc.runner.LayerConfig;
import org.clazzes.svc.runner.OpensDirective;
import org.clazzes.svc.runner.VariableSubstition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final String ETC_PATH_PROPERTY = "svc.runner.etcPath";
    public static final String THROWABLE_HISTORY_SIZE_PROPERTY = "svc.runner.throwableHistorySize";
    public static final String SECURITY_PROVIDERS_PROPERTY = "svc.runner.securityProviders";
    public static final String MODULE_PATH_PROPERTY_PREFIX = "svc.runner.modulePath.";
    public static final String MODULE_PARENT_PROPERTY_PREFIX = "svc.runner.moduleParent.";
    public static final String MODULE_OPENS_PROPERTY_PREFIX = "svc.runner.moduleOpens.";
    private static final Pattern MODULE_LAYER_LABEL_RX;
    private static final Path etcDir;
    private static final SortedMap<String, String> config;
    private static final Map<String, LayerConfig> sortedLayerConfigs;
    private static final Map<String, LayerConfig> layerConfigs;
    private static final String[] LOG_PROPERTIES;
    private static final Logger log;
    private static final Log aclLog;
    private static final java.util.logging.Logger julLogger;

    public static Path getEtcDir() {
        return etcDir;
    }

    public static int getThrowableHistorySize() {
        return Config.getIntProperty(THROWABLE_HISTORY_SIZE_PROPERTY, 10);
    }

    public static Map<String, LayerConfig> getLayerConfigs() {
        return layerConfigs;
    }

    public static Map<String, LayerConfig> getSortedLayerConfigs() {
        return sortedLayerConfigs;
    }

    public static String getProperty(String key) {
        return (String)config.get(key);
    }

    public static String getProperty(String key, String defaultValue) {
        String ret = (String)config.get(key);
        return ret == null ? defaultValue : ret;
    }

    public static int getIntProperty(String key, int defaultValue) {
        String ret = (String)config.get(key);
        return ret == null ? defaultValue : Integer.parseInt(ret);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String ret = (String)config.get(key);
        return ret == null ? defaultValue : Boolean.parseBoolean(ret);
    }

    private static void loadSystemProperties() throws IOException {
        if (etcDir == null) {
            return;
        }
        Properties props = new Properties();
        Path confFile = etcDir.resolve("system.properties");
        if (Files.exists(confFile, new LinkOption[0])) {
            log.info("Loading system properties from [" + String.valueOf(confFile) + "].");
            try (InputStream is = Files.newInputStream(confFile, new OpenOption[0]);){
                props.load(new InputStreamReader(is, "UTF-8"));
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String k = entry.getKey().toString();
                String v = VariableSubstition.substSystemProperties(entry.getValue().toString(), k);
                System.setProperty(k, v);
            }
        }
    }

    private static final void loadProperties(Properties props, Path confDir) throws IOException {
        ArrayList configFiles = new ArrayList();
        Files.newDirectoryStream(confDir, "*.properties").forEach(p -> configFiles.add(p));
        Collections.sort(configFiles);
        for (Path configFile : configFiles) {
            log.info("Loading SVC properties from [" + String.valueOf(configFile) + "].");
            InputStream is = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                props.load(new InputStreamReader(is, "UTF-8"));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static SortedMap<String, String> loadConfigProperties() throws IOException {
        Path confDir;
        Properties props = new Properties();
        if (etcDir != null && Files.isDirectory(confDir = etcDir.resolve("conf.d"), new LinkOption[0])) {
            Config.loadProperties(props, confDir);
        }
        TreeMap<String, String> ret = new TreeMap<String, String>();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement().toString();
            if (!((String)key).startsWith("svc.")) continue;
            ret.put((String)key, System.getProperty((String)key));
        }
        for (Object key : props.keySet()) {
            String k = key.toString();
            String v = VariableSubstition.substConfigProps(k, props);
            ret.put(k, v);
        }
        return ret;
    }

    public static void loadSecretsProperties(Properties props) {
        Path confDir;
        if (etcDir != null && Files.isDirectory(confDir = etcDir.resolve("secrets.d"), new LinkOption[0])) {
            try {
                Config.loadProperties(props, confDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to load secrets from [" + String.valueOf(confDir) + "]", e);
            }
        }
    }

    public static String[] splitCommaSeparatedString(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().split("\\s*,\\s*");
    }

    public static void registerSecurityProviders() throws Exception {
        String[] classNames;
        String secProvProp = Config.getProperty(SECURITY_PROVIDERS_PROPERTY);
        if (secProvProp == null) {
            return;
        }
        ClassLoader cl = Config.class.getClassLoader();
        for (String className : classNames = Config.splitCommaSeparatedString(secProvProp)) {
            if (className.isEmpty()) continue;
            log.info("Registering security provider [" + className + "].");
            Class<?> providerClass = cl.loadClass(className);
            Security.addProvider((Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    static {
        Path etcPath;
        MODULE_LAYER_LABEL_RX = Pattern.compile("^[a-zA-Z_][a-zA-Z_-]*");
        LOG_PROPERTIES = new String[]{"os.name", "os.version", "os.arch", "java.home", "java.class.path", "java.library.path", "java.endorsed.dirs", "java.ext.dirs", "java.io.tmpdir", "jdk.module.path", "file.encoding", "file.separator", "java.specification.name", "java.specification.version", "java.runtime.name", "java.runtime.version", "java.vm.name", "java.vm.version"};
        log = LoggerFactory.getLogger(Config.class);
        aclLog = LogFactory.getLog(Config.class);
        julLogger = java.util.logging.Logger.getLogger(Config.class.getName());
        log.info("Setting up SVC-Runner, system setup is:");
        for (String string : LOG_PROPERTIES) {
            String v = System.getProperty(string);
            if (v == null) continue;
            log.info(" {} = {}", (Object)string, (Object)v);
        }
        log.info(" TimeZone.getDefault() = {}", (Object)TimeZone.getDefault().getID());
        log.info(" Locale.getDefault() = {}", (Object)Locale.getDefault());
        julLogger.info("java.util.logging successfully set up.");
        aclLog.info((Object)"org.apache.commons.logging successfully set up.");
        String etcPathProp = System.getProperty(ETC_PATH_PROPERTY);
        if (etcPathProp == null) {
            etcPath = null;
            log.info("System property [svc.runner.etcPath] is not set, will not read configuration from disk.");
        } else {
            etcPath = Paths.get(etcPathProp, new String[0]);
            if (!Files.isDirectory(etcPath, new LinkOption[0])) {
                throw new RuntimeException("Config etc path [" + String.valueOf(etcPath) + "] does not exist.");
            }
            log.info("Determined svc-runner etc path [" + String.valueOf(etcPath) + "].");
        }
        etcDir = etcPath;
        try {
            Config.loadSystemProperties();
            config = Config.loadConfigProperties();
            layerConfigs = new TreeMap<String, LayerConfig>();
            for (Map.Entry<String, String> entry : config.entrySet()) {
                String k = entry.getKey();
                if (!k.startsWith(MODULE_PATH_PROPERTY_PREFIX) || k.length() <= MODULE_PATH_PROPERTY_PREFIX.length()) continue;
                String lbl = k.substring(MODULE_PATH_PROPERTY_PREFIX.length());
                if (MODULE_LAYER_LABEL_RX.matcher(lbl).matches()) {
                    String parent = (String)config.get(MODULE_PARENT_PROPERTY_PREFIX + lbl);
                    String opensPfx = MODULE_OPENS_PROPERTY_PREFIX + lbl + ".";
                    StringBuilder opensSpec = new StringBuilder();
                    for (Map.Entry<String, String> te : config.tailMap(opensPfx).entrySet()) {
                        if (!te.getKey().startsWith(opensPfx)) break;
                        if (!opensSpec.isEmpty()) {
                            opensSpec.append(',');
                        }
                        opensSpec.append(te.getValue());
                    }
                    Path mp = Path.of(entry.getValue(), new String[0]);
                    List<OpensDirective> opens = OpensDirective.ofSpecList(opensSpec.toString());
                    log.info("Adding [{}] module path [{}] with parent [{}] an opens {}", new Object[]{lbl, mp, parent, opens});
                    layerConfigs.put(lbl, LayerConfig.ofUnresolved(lbl, mp, parent, opens));
                    continue;
                }
                log.warn("Ignoring module path [{}] with invalid label [{}] (must match [{}]).", new Object[]{entry.getValue(), lbl, MODULE_LAYER_LABEL_RX});
            }
            sortedLayerConfigs = new TreeMap<String, LayerConfig>();
            for (Map.Entry<String, Object> entry : layerConfigs.entrySet()) {
                LayerConfig layerConfig = (LayerConfig)entry.getValue();
                String key = layerConfig.resolve(layerConfigs);
                log.info("Resolved layer [{}] to key [{}]", (Object)layerConfig.getLabel(), (Object)key);
                sortedLayerConfigs.put(key, layerConfig);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading svc-runner config.", e);
        }
    }
}

