/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner;

import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import java.util.regex.Pattern;
import org.clazzes.svc.runner.ComponentHolder;

public class ComponentFilter {
    private final String layer;
    private final Pattern namePattern;
    private final ModuleDescriptor.Version moduleVersion;

    protected static final Pattern pmGlob(String glob) {
        String[] parts = glob.split("\\*");
        int i = 0;
        StringBuilder sb = new StringBuilder(Pattern.quote(parts[i++]));
        while (i < parts.length) {
            sb.append(".*");
            sb.append(Pattern.quote(parts[i]));
            ++i;
        }
        return Pattern.compile(sb.toString());
    }

    public ComponentFilter(String layer, Pattern namePattern, ModuleDescriptor.Version moduleVersion) {
        this.layer = layer;
        this.namePattern = namePattern;
        this.moduleVersion = moduleVersion;
    }

    public static ComponentFilter of(String filter) {
        ModuleDescriptor.Version moduleVersion;
        Pattern namePattern;
        String nameAndVersion;
        String layer;
        int spos = filter.indexOf(47);
        if (spos < 0) {
            layer = null;
            nameAndVersion = filter;
        } else {
            layer = filter.substring(0, spos);
            nameAndVersion = filter.substring(spos + 1);
        }
        int atpos = nameAndVersion.lastIndexOf(64);
        if (atpos < 0) {
            namePattern = ComponentFilter.pmGlob(nameAndVersion);
            moduleVersion = null;
        } else {
            namePattern = ComponentFilter.pmGlob(nameAndVersion.substring(0, atpos));
            moduleVersion = ModuleDescriptor.Version.parse(nameAndVersion.substring(atpos + 1));
        }
        return new ComponentFilter(layer, namePattern, moduleVersion);
    }

    public String getLayer() {
        return this.layer;
    }

    public Pattern getNamePattern() {
        return this.namePattern;
    }

    public ModuleDescriptor.Version getModuleVersion() {
        return this.moduleVersion;
    }

    public boolean matches(String layer, ComponentHolder h) {
        return this.matches(layer, h.getClassName(), h.getModuleVersion());
    }

    public boolean matches(String layer, String moduleName, Optional<ModuleDescriptor.Version> v) {
        if (this.layer != null && !this.layer.equals(layer)) {
            return false;
        }
        if (!this.namePattern.matcher(moduleName).matches()) {
            return false;
        }
        return this.moduleVersion == null || !v.isEmpty() && this.moduleVersion.equals(v.get());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.layer != null) {
            sb.append(this.layer);
            sb.append("/");
        }
        sb.append(this.namePattern);
        if (this.moduleVersion != null) {
            sb.append("@");
            sb.append(this.moduleVersion);
        }
        return sb.toString();
    }
}

