/***********************************************************
*
* Service Runner of the clazzes.org project
* https://www.clazzes.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
***********************************************************/

package org.clazzes.svc.runner;

import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class Setup {

    public static final String STOP_TIMEOUT_PROPERTY  = "svc.runner.stopTimeout";
    public static final String KEEPALIVE_TIMEOUT_PROPERTY  = "svc.runner.keepaliveTimeout";

    /**
     * <p>Perform setup actions to be performed before any
     * <code>svc-runner</code>-specific actions.
     * </p>
     *
     * <p>These actions are shared by {@link Main} and {@link Bootstrap}
     * and include log bridge setup and nulling the context class loader.
     * </p>
     * @return the main thread.
     */
    public static Thread setup() {

        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();

        Thread mainThread = Thread.currentThread();

        // context class loader has terrible effects with module layers,
        // so set it to null here.
        // Most prominently, jline3 is unable to load TerminalProviders,
        // if the context class loader is set to its default,
        // the root "app" class loader.
        // So, we set it to null here.
        mainThread.setContextClassLoader(null);

        return mainThread;
    }

}
