/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api.util;

public abstract class SvcUtil {
    public static String bytesHumanReadable(long size) {
        int i;
        long step;
        if (size < 0L) {
            throw new IllegalArgumentException("Negative byte size [" + size + "].");
        }
        long current = step = 1024L;
        String[] SIZES = new String[]{"kB", "MB", "GB", "TB", "PB"};
        for (i = 0; i < SIZES.length - 1 && size >= current * step; ++i) {
            current *= step;
        }
        String unit = SIZES[i];
        long value = Math.round(10.0 * (double)size / (double)current);
        String retVal = Long.toString(value / 10L) + "." + Character.forDigit((int)(value % 10L), 10) + unit;
        return retVal;
    }
}

