/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api.monitoring;

public enum HealthStatus {
    CRITICAL(0.0),
    WARN(0.5),
    OK(1.0),
    HEALTH_CHECK_ERROR(Double.NaN);

    private final double value;

    private HealthStatus(double value) {
        this.value = value;
    }

    public static HealthStatus ofValue(double v) {
        if (v == 1.0) {
            return OK;
        }
        if (v == 0.0) {
            return CRITICAL;
        }
        if (v == 0.5) {
            return WARN;
        }
        if (Double.isNaN(v)) {
            return HEALTH_CHECK_ERROR;
        }
        throw new IllegalArgumentException("Unsupported double value [" + v + "] for HealthStatus.");
    }

    public double getValue() {
        return this.value;
    }
}

