/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api.monitoring;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class HealthInfoWithLog
extends HealthInfo {
    private final List<HealthInfo> log;

    public HealthInfoWithLog(HealthStatus status, List<HealthInfo> log) {
        super(status);
        this.log = log;
    }

    public HealthInfoWithLog(HealthStatus status, String explanation, List<HealthInfo> log) {
        super(status, explanation);
        this.log = log;
    }

    public HealthInfoWithLog(HealthStatus status, String explanation, Throwable exception, List<HealthInfo> log) {
        super(status, explanation, exception);
        this.log = log;
    }

    public static HealthInfoWithLog ofLog(String title, List<HealthInfo> log) {
        return HealthInfoWithLog.ofLogAndTheInfo(title, log, null);
    }

    public static HealthInfoWithLog ofLog(String title, List<HealthInfo> log, Throwable e) {
        HealthInfo theInfo = HealthInfo.ofException(e);
        ArrayList<HealthInfo> realLog = new ArrayList<HealthInfo>(log.size() + 1);
        realLog.addAll(log);
        realLog.add(theInfo);
        return HealthInfoWithLog.ofLogAndTheInfo(title, realLog, theInfo);
    }

    protected static HealthInfoWithLog ofLogAndTheInfo(String title, List<HealthInfo> log, HealthInfo theInfo) {
        HealthStatus status;
        String explanation;
        if (log == null || log.size() == 0) {
            explanation = "No health information log available.";
            status = HealthStatus.HEALTH_CHECK_ERROR;
        } else {
            HealthStatus[] statii = HealthStatus.values();
            int[] counts = new int[statii.length];
            HealthInfo[] topInfos = theInfo == null ? new HealthInfo[statii.length] : null;
            for (HealthInfo info : log) {
                int i;
                int n = i = info.getStatus().ordinal();
                counts[n] = counts[n] + 1;
                if (counts[n] != 1 || topInfos == null) continue;
                topInfos[i] = info;
            }
            status = null;
            StringBuilder sb = new StringBuilder();
            sb.append(title);
            sb.append(" [");
            for (int i = 0; i < statii.length; ++i) {
                int n = counts[i];
                if (n <= 0) continue;
                if (status == null) {
                    status = statii[i];
                    if (theInfo == null && n == 1) {
                        theInfo = topInfos[i];
                    }
                } else {
                    sb.append('/');
                }
                sb.append(n);
                sb.append(' ');
                sb.append((Object)statii[i]);
            }
            sb.append(']');
            if (theInfo != null) {
                sb.append(": ");
                sb.append(theInfo.getExplanation());
            }
            explanation = sb.toString();
        }
        return new HealthInfoWithLog(status, explanation, theInfo == null ? null : theInfo.getException(), log);
    }

    public List<HealthInfo> getLog() {
        return this.log;
    }

    @Override
    public String toString() {
        return "HealthInfoWithLog [status=" + String.valueOf((Object)this.getStatus()) + ", explanation=" + this.getExplanation() + "]";
    }
}

