/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class ConfigurationHelper {
    public static String extractString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        if (o instanceof Supplier) {
            Supplier supp = (Supplier)o;
            return ConfigurationHelper.extractString(supp.get());
        }
        if (o instanceof Number || o instanceof Boolean) {
            return o.toString();
        }
        throw new IllegalArgumentException("Cannot convert object of type [" + String.valueOf(o.getClass()) + "] to String");
    }

    public static Integer extractInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (n.longValue() != (long)n.intValue()) {
                throw new IllegalArgumentException("Long value [" + String.valueOf(n) + "] is out of range for Integer");
            }
            return n.intValue();
        }
        if (o instanceof Supplier) {
            Supplier supp = (Supplier)o;
            return ConfigurationHelper.extractInteger(supp.get());
        }
        if (o instanceof String) {
            String s = (String)o;
            return Integer.valueOf(s);
        }
        throw new IllegalArgumentException("Cannot convert object of type [" + String.valueOf(o.getClass()) + "] to Integer");
    }

    public static Long extractLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.longValue();
        }
        if (o instanceof Supplier) {
            Supplier supp = (Supplier)o;
            return ConfigurationHelper.extractLong(supp.get());
        }
        if (o instanceof String) {
            String s = (String)o;
            return Long.valueOf(s);
        }
        throw new IllegalArgumentException("Cannot convert object of type [" + String.valueOf(o.getClass()) + "] to Long");
    }

    public static Double extractDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.doubleValue();
        }
        if (o instanceof Supplier) {
            Supplier supp = (Supplier)o;
            return ConfigurationHelper.extractDouble(supp.get());
        }
        if (o instanceof String) {
            String s = (String)o;
            return Double.valueOf(s);
        }
        throw new IllegalArgumentException("Cannot convert object of type [" + String.valueOf(o.getClass()) + "] to Double");
    }

    public static Boolean extractBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Supplier) {
            Supplier supp = (Supplier)o;
            return ConfigurationHelper.extractBoolean(supp.get());
        }
        if (o instanceof String) {
            String s = (String)o;
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("String [" + s + "] cannot be converted to boolean.");
        }
        throw new IllegalArgumentException("Cannot convert object of type [" + String.valueOf(o.getClass()) + "] to Integer");
    }

    private static Object getSubItem(Map<String, ?> config, String path) {
        String component;
        int npos;
        Map<String, ?> current = config;
        int i = 1;
        int ipos = 0;
        while ((npos = path.indexOf(46, ipos)) >= 0) {
            component = path.substring(ipos, npos);
            if (component.isBlank()) {
                throw new IllegalArgumentException("Empty path component [" + i + "] in path [" + path + "]");
            }
            Object sub = current.get(component);
            if (sub instanceof Map) {
                Map<String, ?> map;
                current = map = (Map<String, ?>)sub;
            } else if (sub instanceof List) {
                List lst = (List)sub;
                current = ConfigurationHelper.listToMap(lst);
            } else {
                throw new IllegalArgumentException("Non-map in subpath [" + path.substring(0, npos) + "] of path [" + path + "]");
            }
            ipos = npos + 1;
            ++i;
        }
        component = path.substring(ipos);
        if (component.isBlank()) {
            throw new IllegalArgumentException("Empty trailing path component in path [" + path + "]");
        }
        return current.get(component);
    }

    protected static final Map<String, ?> listToMap(List<?> lst) {
        TreeMap ret = new TreeMap();
        for (int i = 0; i < lst.size(); ++i) {
            ret.put(String.valueOf(i + 1), lst.get(i));
        }
        return ret;
    }

    public static Map<String, ?> getSubTree(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        if (sub == null) {
            return null;
        }
        if (sub instanceof Map) {
            Map map = (Map)sub;
            return map;
        }
        if (sub instanceof List) {
            List lst = (List)sub;
            return ConfigurationHelper.listToMap(lst);
        }
        throw new IllegalArgumentException("Non-map at config path [" + path + "]");
    }

    protected static List<?> getList(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        if (sub == null) {
            return null;
        }
        if (sub instanceof List) {
            List lst = (List)sub;
            return lst;
        }
        throw new IllegalArgumentException("Non-list at config path [" + path + "]");
    }

    public static Map<String, ?> getMandatorySubTree(Map<String, ?> config, String path) {
        Map<String, ?> sub = ConfigurationHelper.getSubTree(config, path);
        if (sub == null) {
            throw new IllegalArgumentException("Sub-tree [" + path + "] does not exist.");
        }
        return sub;
    }

    public static String getString(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            return ConfigurationHelper.extractString(sub);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Config value [" + path + "] is not a string", e);
        }
    }

    public static String getMandatoryString(Map<String, ?> config, String path) {
        String s = ConfigurationHelper.getString(config, path);
        if (s == null || s.isBlank()) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return s;
    }

    public static String getString(Map<String, ?> config, String path, String defaultValue) {
        String s = ConfigurationHelper.getString(config, path);
        if (s == null || s.isBlank()) {
            return defaultValue;
        }
        return s;
    }

    public static List<String> getStringList(Map<String, ?> config, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> ConfigurationHelper.extractString(x)).collect(Collectors.toList());
    }

    public static List<String> getMandatoryStringList(Map<String, ?> config, String path) {
        List<String> ret = ConfigurationHelper.getStringList(config, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static <T extends Enum<T>> T getEnum(Map<String, ?> config, Class<T> cls, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            String v = ConfigurationHelper.extractString(sub);
            if (v == null) {
                return null;
            }
            return Enum.valueOf(cls, v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Config value [" + path + "] is not a enum of type [" + cls.getSimpleName() + "]", e);
        }
    }

    public static <T extends Enum<T>> T getMandatoryEnum(Map<String, ?> config, Class<T> cls, String path) {
        T t = ConfigurationHelper.getEnum(config, cls, path);
        if (t == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return t;
    }

    public static <T extends Enum<T>> T getEnum(Map<String, ?> config, Class<T> cls, String path, T defaultValue) {
        T t = ConfigurationHelper.getEnum(config, cls, path);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static <T extends Enum<T>> EnumSet<T> getEnumSet(Map<String, ?> config, Class<T> cls, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        EnumSet ret = EnumSet.noneOf(cls);
        lst.stream().forEach(x -> ret.add(Enum.valueOf(cls, ConfigurationHelper.extractString(x))));
        return ret;
    }

    public static <T extends Enum<T>> EnumSet<T> getMandatoryEnumSet(Map<String, ?> config, Class<T> cls, String path) {
        EnumSet<T> ret = ConfigurationHelper.getEnumSet(config, cls, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static <T> T getParsed(Map<String, ?> config, Function<? super String, T> factory, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            String v = ConfigurationHelper.extractString(sub);
            if (v == null) {
                return null;
            }
            return factory.apply(v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Config value [" + path + "] may not be parsed", e);
        }
    }

    public static <T> T getMandatoryParsed(Map<String, ?> config, Function<? super String, T> factory, String path) {
        T t = ConfigurationHelper.getParsed(config, factory, path);
        if (t == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return t;
    }

    public static <T> T getParsed(Map<String, ?> config, Function<? super String, T> factory, String path, T defaultValue) {
        T t = ConfigurationHelper.getParsed(config, factory, path);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static <T> List<T> getParsedList(Map<String, ?> config, Function<? super String, T> factory, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> factory.apply(ConfigurationHelper.extractString(x))).collect(Collectors.toList());
    }

    public static <T> List<T> getMandatoryParsedList(Map<String, ?> config, Function<? super String, T> factory, String path) {
        List<T> ret = ConfigurationHelper.getParsedList(config, factory, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static Integer getInteger(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            return ConfigurationHelper.extractInteger(sub);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Config value [" + path + "] is not an integer", e);
        }
    }

    public static int getMandatoryInt(Map<String, ?> config, String path) {
        Integer i = ConfigurationHelper.getInteger(config, path);
        if (i == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return i;
    }

    public static int getInt(Map<String, ?> config, String path, int defaultValue) {
        Integer i = ConfigurationHelper.getInteger(config, path);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public static List<Integer> getIntegerList(Map<String, ?> config, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> ConfigurationHelper.extractInteger(x)).collect(Collectors.toList());
    }

    public static List<Integer> getMandatoryIntegerList(Map<String, ?> config, String path) {
        List<Integer> ret = ConfigurationHelper.getIntegerList(config, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static Long getLong(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            return ConfigurationHelper.extractLong(sub);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("long config value [" + path + "] is not a long integer", e);
        }
    }

    public static long getMandatoryLong(Map<String, ?> config, String path) {
        Long i = ConfigurationHelper.getLong(config, path);
        if (i == null) {
            throw new IllegalArgumentException("long config value [" + path + "] has not been specified.");
        }
        return i;
    }

    public static long getLong(Map<String, ?> config, String path, long defaultValue) {
        Long i = ConfigurationHelper.getLong(config, path);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public static List<Long> getLongList(Map<String, ?> config, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> ConfigurationHelper.extractLong(x)).collect(Collectors.toList());
    }

    public static List<Long> getMandatoryLongList(Map<String, ?> config, String path) {
        List<Long> ret = ConfigurationHelper.getLongList(config, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static Double getDouble(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            return ConfigurationHelper.extractDouble(sub);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("double config value [" + path + "] is not a floating point constant", e);
        }
    }

    public static double getMandatoryDouble(Map<String, ?> config, String path) {
        Double i = ConfigurationHelper.getDouble(config, path);
        if (i == null) {
            throw new IllegalArgumentException("double config value [" + path + "] has not been specified.");
        }
        return i;
    }

    public static double getDouble(Map<String, ?> config, String path, double defaultValue) {
        Double i = ConfigurationHelper.getDouble(config, path);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public static List<Double> getDoubleList(Map<String, ?> config, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> ConfigurationHelper.extractDouble(x)).collect(Collectors.toList());
    }

    public static List<Double> getMandatoryDoubleList(Map<String, ?> config, String path) {
        List<Double> ret = ConfigurationHelper.getDoubleList(config, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }

    public static Boolean getBoolean(Map<String, ?> config, String path) {
        Object sub = ConfigurationHelper.getSubItem(config, path);
        try {
            return ConfigurationHelper.extractBoolean(sub);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Config value [" + path + "] is not a boolean", e);
        }
    }

    public static boolean getMandatoryBoolean(Map<String, ?> config, String path) {
        Boolean b = ConfigurationHelper.getBoolean(config, path);
        if (b == null) {
            throw new IllegalArgumentException("boolean config value [" + path + "] has not been specified.");
        }
        return b;
    }

    public static boolean getBoolean(Map<String, ?> config, String path, boolean defaultValue) {
        Boolean b = ConfigurationHelper.getBoolean(config, path);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public static List<Boolean> getBooleanList(Map<String, ?> config, String path) {
        List<?> lst = ConfigurationHelper.getList(config, path);
        if (lst == null) {
            return null;
        }
        return lst.stream().map(x -> ConfigurationHelper.extractBoolean(x)).collect(Collectors.toList());
    }

    public static List<Boolean> getMandatoryBooleanList(Map<String, ?> config, String path) {
        List<Boolean> ret = ConfigurationHelper.getBooleanList(config, path);
        if (ret == null) {
            throw new IllegalArgumentException("Config value [" + path + "] has not been specified.");
        }
        return ret;
    }
}

