/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.clazzes.svc.api.ConfigurationHelper;

public class ConfigWrapper {
    private final String pid;
    private final Map<String, ?> content;

    public ConfigWrapper(String pid, Map<String, ?> content) {
        this.pid = pid;
        this.content = content;
    }

    public String toString() {
        return "ConfigWrapper[pid=" + this.pid + "]";
    }

    public Map<String, ?> getContent() {
        return this.content;
    }

    public Set<String> keySet() {
        return this.content.keySet();
    }

    private String subPid(String key) {
        return this.pid + "/" + key.replace('.', '/');
    }

    public ConfigWrapper getSubTree(String path) {
        Map<String, ?> sub = ConfigurationHelper.getSubTree(this.content, path);
        if (sub == null) {
            return null;
        }
        return new ConfigWrapper(this.subPid(path), sub);
    }

    public ConfigWrapper getMandatorySubTree(String path) {
        Map<String, ?> sub = ConfigurationHelper.getMandatorySubTree(this.content, path);
        return new ConfigWrapper(this.subPid(path), sub);
    }

    public String getString(String path) {
        return ConfigurationHelper.getString(this.content, path);
    }

    public String getMandatoryString(String path) {
        return ConfigurationHelper.getMandatoryString(this.content, path);
    }

    public String getString(String path, String defaultValue) {
        return ConfigurationHelper.getString(this.content, path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return ConfigurationHelper.getStringList(this.content, path);
    }

    public List<String> getMandatoryStringList(String path) {
        return ConfigurationHelper.getMandatoryStringList(this.content, path);
    }

    public <T extends Enum<T>> T getEnum(Class<T> cls, String path) {
        return ConfigurationHelper.getEnum(this.content, cls, path);
    }

    public <T extends Enum<T>> T getMandatoryEnum(Class<T> cls, String path) {
        return ConfigurationHelper.getMandatoryEnum(this.content, cls, path);
    }

    public <T extends Enum<T>> T getEnum(Class<T> cls, String path, T defaultValue) {
        return ConfigurationHelper.getEnum(this.content, cls, path, defaultValue);
    }

    public <T extends Enum<T>> EnumSet<T> getEnumSet(Class<T> cls, String path) {
        return ConfigurationHelper.getEnumSet(this.content, cls, path);
    }

    public <T extends Enum<T>> EnumSet<T> getMandatoryEnumSet(Class<T> cls, String path) {
        return ConfigurationHelper.getMandatoryEnumSet(this.content, cls, path);
    }

    public <T> T getParsed(Function<? super String, T> factory, String path) {
        return ConfigurationHelper.getParsed(this.content, factory, path);
    }

    public <T> T getMandatoryParsed(Function<? super String, T> factory, String path) {
        return ConfigurationHelper.getMandatoryParsed(this.content, factory, path);
    }

    public <T> T getParsed(Function<? super String, T> factory, String path, T defaultValue) {
        return ConfigurationHelper.getParsed(this.content, factory, path, defaultValue);
    }

    public <T> List<T> getParsedList(Function<? super String, T> factory, String path) {
        return ConfigurationHelper.getParsedList(this.content, factory, path);
    }

    public <T> List<T> getMandatoryParsedList(Function<? super String, T> factory, String path) {
        return ConfigurationHelper.getMandatoryParsedList(this.content, factory, path);
    }

    public Integer getInteger(String path) {
        return ConfigurationHelper.getInteger(this.content, path);
    }

    public int getMandatoryInt(String path) {
        return ConfigurationHelper.getMandatoryInt(this.content, path);
    }

    public int getInt(String path, int defaultValue) {
        return ConfigurationHelper.getInt(this.content, path, defaultValue);
    }

    public List<Integer> getIntegerList(String path) {
        return ConfigurationHelper.getIntegerList(this.content, path);
    }

    public List<Integer> getMandatoryIntegerList(String path) {
        return ConfigurationHelper.getMandatoryIntegerList(this.content, path);
    }

    public Long getLong(String path) {
        return ConfigurationHelper.getLong(this.content, path);
    }

    public long getMandatoryLong(String path) {
        return ConfigurationHelper.getMandatoryLong(this.content, path);
    }

    public long getLong(String path, long defaultValue) {
        return ConfigurationHelper.getLong(this.content, path, defaultValue);
    }

    public List<Long> getLongList(String path) {
        return ConfigurationHelper.getLongList(this.content, path);
    }

    public List<Long> getMandatoryLongList(String path) {
        return ConfigurationHelper.getMandatoryLongList(this.content, path);
    }

    public Double getDouble(String path) {
        return ConfigurationHelper.getDouble(this.content, path);
    }

    public double getMandatoryDouble(String path) {
        return ConfigurationHelper.getMandatoryDouble(this.content, path);
    }

    public double getDouble(String path, double defaultValue) {
        return ConfigurationHelper.getDouble(this.content, path, defaultValue);
    }

    public List<Double> getDoubleList(String path) {
        return ConfigurationHelper.getDoubleList(this.content, path);
    }

    public List<Double> getMandatoryDoubleList(String path) {
        return ConfigurationHelper.getMandatoryDoubleList(this.content, path);
    }

    public Boolean getBoolean(String path) {
        return ConfigurationHelper.getBoolean(this.content, path);
    }

    public boolean getMandatoryBoolean(String path) {
        return ConfigurationHelper.getMandatoryBoolean(this.content, path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return ConfigurationHelper.getBoolean(this.content, path, defaultValue);
    }

    public List<Boolean> getBooleanList(String path) {
        return ConfigurationHelper.getBooleanList(this.content, path);
    }

    public List<Boolean> getMandatoryBooleanList(String path) {
        return ConfigurationHelper.getMandatoryBooleanList(this.content, path);
    }

    public String getPid() {
        return this.pid;
    }
}

