/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.clazzes.svc.api.ServiceKey;
import org.clazzes.svc.api.ServiceRegistry;

public class ComponentSupport {
    Logger log = Logger.getLogger(ComponentSupport.class.getName());
    private List<AutoCloseable> listeners;
    private List<ServiceKey<?>> services;

    public <T> void addService(ServiceRegistry serviceRegistry, String key, Class<T> iface, T service) {
        serviceRegistry.addService(key, iface, service);
        if (this.services == null) {
            this.services = new ArrayList();
        }
        this.services.add(new ServiceKey<T>(key, iface));
    }

    public void removeAllServices(ServiceRegistry serviceRegistry) {
        if (this.services != null) {
            for (int i = this.services.size() - 1; i >= 0; --i) {
                ServiceKey<?> sk = this.services.get(i);
                serviceRegistry.removeService(sk.getKey(), sk.getIface());
            }
            this.services = null;
        }
    }

    public void addListener(AutoCloseable closeable) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<AutoCloseable>();
        }
        this.listeners.add(closeable);
    }

    public void closeAllListeners(BiConsumer<AutoCloseable, Exception> suppressedHandler) {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                AutoCloseable listener = this.listeners.get(i);
                try {
                    listener.close();
                    continue;
                }
                catch (Exception e) {
                    suppressedHandler.accept(listener, e);
                }
            }
            this.listeners = null;
        }
    }

    public void closeAllListeners() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                AutoCloseable listener = this.listeners.get(i);
                try {
                    listener.close();
                    continue;
                }
                catch (Exception e) {
                    this.log.warning("Error closing listener " + String.valueOf(listener) + ":" + String.valueOf(e));
                }
            }
            this.listeners = null;
        }
    }
}

