/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.util.List;
import org.clazzes.svc.api.ComponentState;
import org.clazzes.svc.api.HasThrowableInfos;
import org.clazzes.svc.api.ModuleInfo;
import org.clazzes.svc.api.ThrowableInfo;

public class ComponentInfo
extends HasThrowableInfos
implements Comparable<ComponentInfo> {
    private static final long serialVersionUID = 4292571560841637366L;
    private final String name;
    private final int priority;
    private final ComponentState state;
    private final ModuleInfo module;

    public ComponentInfo(String name, int priority, ComponentState state, ModuleInfo module) {
        this.name = name;
        this.priority = priority;
        this.state = state;
        this.module = module;
    }

    public ComponentInfo(String name, int priority, ComponentState state, ModuleInfo module, List<ThrowableInfo> throwables) {
        super(throwables);
        this.name = name;
        this.priority = priority;
        this.state = state;
        this.module = module;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public ComponentState getState() {
        return this.state;
    }

    public ModuleInfo getModule() {
        return this.module;
    }

    @Override
    public int compareTo(ComponentInfo o) {
        if (this.getPriority() < o.getPriority()) {
            return -1;
        }
        if (this.getPriority() > o.getPriority()) {
            return 1;
        }
        String no = o.getName();
        if (this.name == null) {
            return no == null ? 0 : -1;
        }
        if (no == null) {
            return 1;
        }
        return this.name.compareTo(no);
    }
}

