/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api.util;

public abstract class SvcUtil {

    /**
     * Utility method to return any magnitude of bytes in a human readable
     * format using the appropriate unit (kB, MB, GB, TB or PB)
     * depending on the magnitude of the input.
     *
     * @param size in bytes
     * @return a human readable result
     */
    public static String bytesHumanReadable(long size) {

        if (size<0L) {
            throw new IllegalArgumentException("Negative byte size ["+size+"].");
        }

        long step = 1024L;
        long current = step;
        final String SIZES[] = { "kB", "MB", "GB", "TB", "PB" };
        int i;
        for (i = 0; i < SIZES.length - 1; ++i) {
            if (size < current * step) {
                break;
            }
            current *= step;
        }

        String unit = SIZES[i];

        long value = Math.round((10.0 * size) / current);

        String retVal = Long.toString(value/10L) + '.' + Character.forDigit((int)(value%10L),10) + unit;
        return retVal;
    }

}
