/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api.monitoring;

import java.util.List;

/**
 * <p>Interface for a tagged HealtCheck, Counter or Gauge.</p>
 *
 * <p>The ID of the item is the key under which it is exported
 * via <code>ServiceRegistry.addService()</code>
 */
public interface TaggedMetrics {

    /**
     * @return The ID this health check. The heltch check is registered
     *         with this ID as key by means of
     *         <code>ServiceRegistry.addService()</code>.
     */
    public String getId();

    /**
     * @return A description for this health check.
     */
    public String getDescription();

    /**
     * @return A list of tags used to filter health checks.
     */
    public List<String> getTags();

    /**
     * <p>A time to live in milliseconds, which protects synchronous checks
     * from being evaluated too often.</p>
     *
     * @return A time to life in milliseconds, which defaults to 10.
     */
    public default long getTTLMillis() {
        return 10L;
    }
}
