/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api.monitoring;

/**
 * <p>Additional interface for a gauge or counter, which
 * exposes it as an openmetrics histogram.</p>
 *
 * @see <a href="https://github.com/prometheus/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram">OpenMetrics Spec</a>
 */
public interface Histogram extends AsyncMetrics {

    /**
     * <p>All LE value for breaking down the histogram.
     * The <code>+Inf</code> LE value is automatically created by the
     * monitoring engine and should not be part of the returned array.</p>
     *
     * @return All sorted LE values excluding <code>+Inf</code>.
     *
     */
    public double[] getLEValues();
}
