/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api.monitoring;

import java.util.concurrent.Callable;

/**
 * <p>Interface for a health check.</p>
 *
 * <p>If {@link AsyncMetrics} is additionally implemented, the check
 * is executed at a fixed rate. In this case, {@link Summary} or {@link Histogram}
 * might be additionally implemented.</p>
 */
public interface HealthCheck extends Callable<HealthInfo>,TaggedMetrics {

}
