/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api.monitoring;

import java.util.concurrent.ScheduledExecutorService;

/**
 * Interface for a counter or health check, which is executed
 * asynchronously at a fixed rate.
 */
public interface AsyncMetrics {

    /**
     * An execution interval in seconds. The check is executed at a fixed rate,
     * so please assure, that the actual execution of the check does not take more
     * time then this interval.
     *
     * @return An execution interval in secdonds.
     *
     * @see ScheduledExecutorService#scheduleAtFixedRate(Runnable,long,long,java.util.concurrent.TimeUnit)
     */
    public long getIntervalSeconds();

    /**
     * @return The number of retries before we change to
     *         {@link HealthStatus#HEALTH_CHECK_ERROR}.
     */
    public default int getMaxRetries() { return 0; }
}
