/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.io.Serializable;

/**
 * An information on a catched execption by some listeners.
 */
public class ThrowableInfo implements Serializable {

    private static final long serialVersionUID = -5597357372978587644L;

    private final long timestamp;
    private final String message;
    private final Throwable throwable;

    /**
     * Contruct a throwable info using the current timestamp as returned
     * by {@link System#currentTimeMillis()}.
     *
     * @param message The message including context information.
     * @param throwable The throwable.
     */
    public ThrowableInfo(String message, Throwable throwable) {
        this.timestamp = System.currentTimeMillis();
        this.message = message;
        this.throwable = throwable;
    }

    /**
     * Contruct a throwable info using the given milliseconds timestamp.
     *
     * @param timestamp The timestamp in milliseconds since the epoch.
     * @param message The message including context information.
     * @param throwable The throwable.
     */
    public ThrowableInfo(long timestamp, String message, Throwable throwable) {
        this.timestamp = timestamp;
        this.message = message;
        this.throwable = throwable;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

}
