/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>An annotation to prioritize component.
 * </p>
 * <p>Priorities are categorized as follows:
 * </p>
 * <ul>
 *   <li><code>1-9</code>
 *     System components like configuration management, SSH console,
 *     HTTP Server.
 *   </li>
 *   <li><code>10-49</code>
 *     Infrastructure components like JDBC connection manager,
 *     schema maangement services.
 *   </li>
 *   <li><code>50-99</code>
 *     Application components.
 *   </li>
 *   <li><code>100</code>
 *     Unprioritized components.
 *   </li>
 * </ul>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ServicePriority {

    public static final int DEFAULT_PROIRITY = 100;

    /**
     * @return The service priority.
     */
    int value();
}
