/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

/**
 * A key for a registered service.
 */
public final class ServiceKey<T> {

    final String key;
    private final Class<T> iface;

    public ServiceKey(String key, Class<T> iface) {
        this.key = key;
        this.iface = iface;
    }

    @Override
    public String toString() {

        return "Service["+this.key+","+this.iface.getName()+"]";
    }

    public String getKey() {
        return this.key;
    }

    public Class<T> getIface() {
        return this.iface;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((key == null) ? 0 : key.hashCode());
        result = prime * result + ((iface == null) ? 0 : iface.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        @SuppressWarnings("rawtypes")
        ServiceKey other = (ServiceKey) obj;
        if (key == null) {
            if (other.key != null)
                return false;
        } else if (!key.equals(other.key))
            return false;
        if (iface == null) {
            if (other.iface != null)
                return false;
        } else if (!iface.equals(other.iface))
            return false;
        return true;
    }
}
