/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.util.List;

/**
 * An information on a deployed java module.
 */
public class ServiceInfo extends HasThrowableInfos implements Comparable<ServiceInfo> {

    private static final long serialVersionUID = -2895062435144960426L;

    private final String iface;
    private final String key;
    private final String implementation;

    /**
     * @param iface The name of the interface class.
     * @param key The service key.
     * @param implementation The name of the implementing class.
     */
    public ServiceInfo(String iface, String key, String implementation) {
        this.iface = iface;
        this.key = key;
        this.implementation = implementation;
    }

    /**
     * @param iface The name of the interface class.
     * @param key The service key.
     * @param implementation The name of the implementing class.
     * @param throwables The exception infos of errors caught by listeners
     *                   for this service.
     */
    public ServiceInfo(String iface, String key, String implementation,
                       List<ThrowableInfo> throwables) {
        super(throwables);
        this.iface = iface;
        this.key = key;
        this.implementation = implementation;
    }
    public String getIface() {
        return iface;
    }

    public String getKey() {
        return key;
    }

    public String getImplementation() {
        return implementation;
    }

    @Override
    public int compareTo(ServiceInfo o) {

        String io = o.getIface();

        if (this.iface == null) {
            return io == null ? 0 : -1;
        }
        else if (io == null) {
            return 1;
        }

        int ret = this.iface.compareTo(io);

        if (ret != 0) {
            return ret;
        }

        String ko = o.getKey();

        if (this.key == null) {
            return ko == null ? 0 : -1;
        }
        else if (ko == null) {
            return 1;
        }

        return this.key.compareTo(ko);
    }

}
