/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.io.Serializable;
import java.util.List;

/**
 * A colelction of throwable informations.
 */
public class HasThrowableInfos implements Serializable {

    private static final long serialVersionUID = -8798234870031838895L;

    private final List<ThrowableInfo> throwables;

    public HasThrowableInfos() {
        this.throwables = null;
    }

    public HasThrowableInfos(List<ThrowableInfo> throwables) {
        this.throwables = throwables;
    }

    public List<ThrowableInfo> getThrowables() {
        return this.throwables;
    }

}
