/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

/**
 * <p>A service, which provides executor services and access to service
 * secrets.
 * </p>
 */
public interface CoreService {

    /**
     * @return The configured configuration directory path or <code>null</code>,
     *         if no such path has been configured through the system property
     *         <code>svc.runner.etcPath</code>. The second case happens, when
     *         we are run as part of a test case.
     */
    public Path getEtcDir();

    /**
     * @return The centralized executor used for background jobs.
     */
    public ExecutorService getExecutorService();

    /**
     * @return The centralized scheduled executor service used for
     *         background jobs to be executed at a given point in time.
     */
    public ScheduledExecutorService getScheduledExecutorService();

    /**
     * @param pid The name of the configuration set for which to fetch
     *            the secret value. This name might be used to decrypt the
     *            secret.
     * @param scheme The secret scheme, known schemes are <code>env</code>,
     *               <code>prop</code> or <code>void</code>.
     * @param key The key of the secret, which might be an enviroment
     *            variable name or the key in a secret properties files.
     * @return The value of the secret.
     */
    public String getSecret(String pid, String scheme, String key);
}
