/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * A configuration engine providing structured configurations
 * to components.
 */
public interface ConfigurationEngine {

    /**
     * Listen on for config changes.
     * @param pid The configuration set name.
     * @param updated A callback executed when the configuration becomes available.
     * @return A closeable, which terminates the subscription when closed.
     */
    public AutoCloseable listen(String pid,
                                Consumer<ConfigWrapper> updated);

    /**
     * List all PIDs for informational purposes.
     * @return A list of PID informations.
     */
    public List<ConfigPidInfo> listPids();

    /**
     * Get the currently loaded config for the given PID.
     * @param pid The configuration set name.
     * @return An optional map with the config.
     */
    public Optional<ConfigWrapper> getPid(String pid);
}
