/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

/**
 * <p>A component state.
 * </p>
 */
public enum ComponentState {

    /**
     * Component loaded from the module path.
     */
    LOADED,
    /**
     * {@link Component#start(ServiceContext)} method is running.
     */
    STARTING,
    /**
     * {@link Component#start(ServiceContext)} method failed with exception.
     */
    START_FAILED,
    /**
     * {@link Component#start(ServiceContext)} method succeeded.
     */
    STARTED,
    /**
     * {@link Component#stop(ServiceContext)} method is running.
     */
    STOPPING,
    /**
     * {@link Component#stop(ServiceContext)} method failed with exception.
     */
    STOP_FAILED,
    /**
     * {@link Component#stop(ServiceContext)} method succeeded.
     */
    STOPPED,
    /**
     * The component has been committed on the application layer by
     * {@link ComponentManager#commit()}.
     */
    COMMITTED,
    /**
     * A listener registered to
     * {@link ConfigurationEngine#listen(String, java.util.function.Consumer)}
     * failed.
     */
    CONFIG_LISTENER_FAILED,
    /**
     * A listener registered to
     * {@link ServiceRegistry#listen(String, Class, java.util.function.Consumer, java.util.function.Consumer)}
     * or
     * {@link ServiceRegistry#listenAll(Class, java.util.function.BiConsumer, java.util.function.BiConsumer)}
     * failed.
     */
    SERVICE_LISTENER_FAILED
}
