/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

import java.io.Serializable;

/**
 * An information on a deployed java module.
 */
public class ComponentLayerInfo implements Serializable {

    private static final long serialVersionUID = 7853864598728668221L;

    private final String label;
    private final String path;
    private final String parent;

    /**
     * @param label The layer label, which is <code>$boot</code> for the boot layer.
     * @param path The filesysytem path of the layer, which might be comma-separated
     *             for the boot layer.
     */
    public ComponentLayerInfo(String label, String path) {
        this(label,path,null);
    }

    /**
     * @param label The layer label, which is <code>$boot</code> for the boot layer.
     * @param path The filesysytem path of the layer, which might be comma-separated
     *             for the boot layer.
     * @param parent The label of the parent layer.
     */
    public ComponentLayerInfo(String label, String path, String parent) {
        this.label = label;
        this.path = path;
        this.parent = parent;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public String getParent() {
        return this.parent;
    }

}
