/***********************************************************
 *
 * Service API of the clazzes.org project
 * https://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.api;

/**
 * <p>A component with a lifecycle exported to be started by an IoC
 * container resolving all <code>Component</code> implementations
 * as a Java service in their <code>module-info.java</code> descriptor.
 * </p>
 */
public interface Component {

    /**
     * <p>Start this component, initializing configuration listeners, starting
     * server resources, registering services in {@link ServiceRegistry}
     * and the like.
     * </p>
     *
     * @param context The service context.
     * @throws Exception Upon initialization errors. It is assumed, that
     *             the component cleans up all half-initialized resources
     *             upon exceptions.
     */
    public void start(ServiceContext context) throws Exception;

    /**
     * <p>Stop the component by stopping server components, closing service
     * and configuration subscriptions and the like.
     * </p>
     *
     * @param context The service context.
     * @throws Exception Upon shutdown errors.Implementors are adviced
     *             to avoid throwing execptions at this point and to implement
     *             fail-safe service stopping.
     */
    public void stop(ServiceContext context) throws Exception;
}
