/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.yubikey;

import org.clazzes.login.yubikey.YubiKeyOtpCheckerImpl;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.sec.TokenOtpChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YubiKeyComponent
implements Component {
    private static final Logger log = LoggerFactory.getLogger(YubiKeyComponent.class);
    public static final String CONFIG_PID = "org.clazzes.login.yubikey";
    public static final String SERVICE_KEY = "yubikey";
    private TokenOtpChecker tokenOtpChecker;

    protected void stopChecker(ServiceRegistry registry) {
        if (this.tokenOtpChecker != null) {
            registry.removeService(SERVICE_KEY, TokenOtpChecker.class);
            this.tokenOtpChecker = null;
        }
    }

    public void start(ServiceContext context) throws Exception {
        ConfigurationEngine ce = (ConfigurationEngine)context.getService(ConfigurationEngine.class).get();
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = (ComponentManager)context.getService(ComponentManager.class).get();
        ce.listen(CONFIG_PID, config -> {
            YubiKeyOtpCheckerImpl oci = new YubiKeyOtpCheckerImpl();
            oci.setConnectTimeout(config.getInt("connectTimeoutMillis", 60000));
            oci.setYubikeyVerifyLocation(config.getString("yubikeyVerifyLocation", "https://api.yubico.com/wsapi/2.0/verify"));
            oci.setYubikeyRequestorId(config.getString("yubikeyRequestorId", ""));
            log.info("Starting [{}]", (Object)oci);
            YubiKeyComponent yubiKeyComponent = this;
            synchronized (yubiKeyComponent) {
                this.stopChecker(registry);
                registry.addService(SERVICE_KEY, TokenOtpChecker.class, (Object)oci);
                this.tokenOtpChecker = oci;
            }
        });
        componentManager.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ServiceContext context) throws Exception {
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        YubiKeyComponent yubiKeyComponent = this;
        synchronized (yubiKeyComponent) {
            this.stopChecker(registry);
        }
    }
}

