/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.yubikey;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.TokenOtpChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YubiKeyOtpCheckerImpl
implements TokenOtpChecker {
    private static final Logger log = LoggerFactory.getLogger(YubiKeyOtpCheckerImpl.class);
    private int connectTimeout = 60000;
    private String yubikeyVerifyLocation;
    private String yubikeyRequestorId;

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkOTP(String otp, String[] knownIds) throws IOException {
        if (otp == null || otp.length() < 12) {
            return false;
        }
        id = otp.substring(0, 12);
        otpOk = false;
        for (String knownId : knownIds) {
            otpOk |= knownId.equals(id);
        }
        if (!otpOk) {
            YubiKeyOtpCheckerImpl.log.error("Yubikey ID [{}] is not in the list of known YubiKe IDs [{}].", (Object)id, (Object)Arrays.toString(knownIds));
            return false;
        }
        nonce = HashTools.randomSalt((int)20, (String)"0123456789abcdef");
        url = UrlHelper.appendQueryParameterToUrl((String)this.yubikeyVerifyLocation, (String)"otp", (String)otp);
        url = UrlHelper.appendQueryParameterToUrl((String)url, (String)"id", (String)this.yubikeyRequestorId);
        url = UrlHelper.appendQueryParameterToUrl((String)url, (String)"nonce", (String)nonce);
        uri = URI.create(url);
        req = HttpRequest.newBuilder(uri).timeout(Duration.of(this.connectTimeout, ChronoUnit.MILLIS)).build();
        if (YubiKeyOtpCheckerImpl.log.isDebugEnabled()) {
            YubiKeyOtpCheckerImpl.log.debug("Performing Yubikey check request to [{}]...", (Object)url);
        }
        client = HttpClient.newHttpClient();
        try {
            resp = client.send(req, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("OTP Request to [" + url + "] has been interrupted.");
        }
        is = resp.body();
        try {
            status = resp.statusCode();
            if (status != 200) ** GOTO lbl61
            kvs = new HashMap<String, String>();
            reader = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
            try {
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    epos = line.indexOf(61);
                    if (epos < 0) {
                        kvs.put(line, null);
                        continue;
                    }
                    kvs.put(line.substring(0, epos), line.substring(epos + 1));
                }
            }
            finally {
                reader.close();
            }
            if (YubiKeyOtpCheckerImpl.log.isDebugEnabled()) {
                YubiKeyOtpCheckerImpl.log.debug("Yubikey check request to [{}] returned [{}]", (Object)url, kvs);
            }
            if (!"OK".equals(kvs.get("status"))) {
                YubiKeyOtpCheckerImpl.log.error("Yubikey check request to [{}] returned negative status [{}].", (Object)url, kvs.get("status"));
            } else if (!otp.equals(kvs.get("otp"))) {
                YubiKeyOtpCheckerImpl.log.error("Yubikey check request to [{}] returned non-matching OTP [{}].", (Object)url, kvs.get("otp"));
            } else if (!nonce.equals(kvs.get("nonce"))) {
                YubiKeyOtpCheckerImpl.log.error("Yubikey check request to [{}] returned non-matching nonce [{}].", (Object)url, kvs.get("nonce"));
            } else {
                YubiKeyOtpCheckerImpl.log.info("Yubikey check request to [{}] succeeded.", (Object)url);
                var14_20 = true;
                return var14_20;
lbl61:
                // 1 sources

                YubiKeyOtpCheckerImpl.log.error("Yubikey check request to [{}] failed with HTTP reponse code [{}].", (Object)url, (Object)status);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return false;
    }

    public void setYubikeyVerifyLocation(String yubikeyVerifyLocation) {
        this.yubikeyVerifyLocation = yubikeyVerifyLocation;
    }

    public void setYubikeyRequestorId(String yubikeyRequestorId) {
        this.yubikeyRequestorId = yubikeyRequestorId;
    }
}

