/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth.impl;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.clazzes.login.jbo.jwt.JWToken;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.OAuthHttpClient;
import org.clazzes.login.oauth.OAuthRobotCredentials;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.RobotGrantType;
import org.clazzes.login.oauth.TokenValidator;
import org.clazzes.login.oauth.i18n.OAuthMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotCredentialsSupplier
implements Supplier<OAuthRobotCredentials> {
    private static final Logger log = LoggerFactory.getLogger(RobotCredentialsSupplier.class);
    private final OAuthHttpClient oauthHttpClient;
    private final TokenValidator tokenValidator;
    private final DomainManager domainManager;
    private final Clock clock;
    private OAuthRobotCredentials credentials;
    private boolean queryRunning;

    public RobotCredentialsSupplier(OAuthHttpClient oauthHttpClient, TokenValidator tokenValidator, DomainManager domainManager) {
        this(oauthHttpClient, tokenValidator, domainManager, Clock.systemDefaultZone());
    }

    public RobotCredentialsSupplier(OAuthHttpClient oauthHttpClient, TokenValidator tokenValidator, DomainManager domainManager, Clock clock) {
        this.oauthHttpClient = oauthHttpClient;
        this.tokenValidator = tokenValidator;
        this.domainManager = domainManager;
        this.clock = clock;
    }

    private OAuthRobotCredentials getInternal() throws Exception {
        OAuthTokenResponse resp;
        String scope = this.domainManager.getDomainConfig().getRobotScope();
        PasswordAuthentication clientCredentials = this.domainManager.getDomainConfig().getRobotCredentials();
        URI tokenUri = this.domainManager.getTokenUri();
        RobotGrantType grantType = this.domainManager.getDomainConfig().getRobotGrantType();
        if (grantType == RobotGrantType.client_credentials) {
            resp = this.oauthHttpClient.requestRobotToken(tokenUri, scope, clientCredentials, this.domainManager.getDomainConfig().getOptions());
        } else if (grantType == RobotGrantType.password) {
            PasswordAuthentication userCred = this.domainManager.getDomainConfig().getRobotUserCredentials();
            if (userCred == null) {
                throw new IllegalStateException("No userId given for robot flow [" + String.valueOf((Object)grantType) + "] for domain [" + this.domainManager.getDomainConfig().getDomain() + "]");
            }
            resp = this.oauthHttpClient.requestPasswordFlowToken(tokenUri, scope, clientCredentials, userCred, this.domainManager.getDomainConfig().getOptions());
        } else {
            throw new IllegalStateException("Unsupported robot flow [" + String.valueOf((Object)grantType) + "] for domain [" + this.domainManager.getDomainConfig().getDomain() + "]");
        }
        HashMap<String, String> additionalAttributes = null;
        if (resp.getIdToken() != null) {
            JWToken token = this.tokenValidator.validateRobotToken(this.domainManager, resp, OAuthMessages.getMesssages(Locale.ENGLISH));
            Map additionalClaims = token.getClaimSet().getAdditionalClaims();
            additionalAttributes = new HashMap<String, String>();
            for (Map.Entry e : additionalClaims.entrySet()) {
                additionalAttributes.put((String)e.getKey(), e.getValue().toString());
            }
        }
        long expiry = resp.getTimestamp();
        Long maxAge = resp.getExpiresIn();
        if (maxAge == null) {
            log.warn("Got no expiry for robot token for domain [{}], falling back to 1 minute timeout.", (Object)this.domainManager.getDomain());
            expiry += 60000L;
        } else {
            expiry += maxAge.longValue();
            expiry -= maxAge / 10L;
        }
        return new OAuthRobotCredentials(resp.getAccessToken(), additionalAttributes, expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthRobotCredentials get() {
        try {
            RobotCredentialsSupplier robotCredentialsSupplier = this;
            synchronized (robotCredentialsSupplier) {
                if (this.queryRunning) {
                    if (log.isDebugEnabled()) {
                        log.debug("Waiting a minute for OAuth robot token query for domain [{}] in other thread...", (Object)this.domainManager.getDomain());
                    }
                    while (true) {
                        this.wait(60000L);
                        if (!this.queryRunning) break;
                        log.warn("OAuth robot token query for domain [{}] still running in other thread, waiting another minute...", (Object)this.domainManager.getDomain());
                    }
                    if (this.credentials == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("OAuth robot token query for domain [{}] failed in other thread.", (Object)this.domainManager.getDomain());
                        }
                        throw new IllegalStateException("Unable to issue a robot token for domain [" + this.domainManager.getDomain() + "]");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("OAuth robot token query for domain [{}] successfully finished in other thread.", (Object)this.domainManager.getDomain());
                    }
                    return this.credentials;
                }
                long now = Instant.now(this.clock).toEpochMilli();
                if (this.credentials != null && this.credentials.getRefreshMillis() > now) {
                    if (log.isDebugEnabled()) {
                        log.debug("Returning already issued OAuth robot token [{}] for domain [{}].", (Object)this.credentials, (Object)this.domainManager.getDomain());
                    }
                    return this.credentials;
                }
                if (log.isDebugEnabled() && this.credentials != null) {
                    log.debug("OAuth robot token [{}] for domain [{}] is expired, refreshing it now...", (Object)this.credentials, (Object)this.domainManager.getDomain());
                }
                this.queryRunning = true;
            }
            OAuthRobotCredentials cred = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Querying new OAuth robot token for domain [{}]...", (Object)this.domainManager.getDomain());
                }
                cred = this.getInternal();
                if (log.isDebugEnabled() && log.isDebugEnabled()) {
                    log.debug("Successfully issued new OAuth robot token [{}] for domain [{}].", (Object)cred, (Object)this.domainManager.getDomain());
                }
            }
            finally {
                RobotCredentialsSupplier robotCredentialsSupplier2 = this;
                synchronized (robotCredentialsSupplier2) {
                    this.credentials = cred;
                    this.queryRunning = false;
                    this.notifyAll();
                }
            }
            return cred;
        }
        catch (Exception e) {
            log.error("Error issuing robot token for domain [" + this.domainManager.getDomain() + "]", (Throwable)e);
            throw new IllegalStateException("Unable to issue a robot token for domain [" + this.domainManager.getDomain() + "]");
        }
    }
}

