/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.login.jbo.jwt.JWKPubKey;
import org.clazzes.login.jbo.jwt.JWKeyParser;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.JsonConfigParser;
import org.clazzes.login.oauth.OAuthHttpClient;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.clazzes.login.oauth.OAuthTokenResponseParser;
import org.clazzes.login.oauth.RobotGrantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHttpClientImpl
implements OAuthHttpClient {
    private static final Logger log = LoggerFactory.getLogger(OAuthHttpClientImpl.class);
    private Duration timeout;
    private HttpClient client = HttpClient.newHttpClient();
    private Clock clock = Clock.systemDefaultZone();

    public OAuthHttpClientImpl() {
        this.timeout = Duration.ofSeconds(30L);
    }

    protected HttpResponse<InputStream> performRequest(HttpRequest req) throws IOException {
        try {
            return this.client.send(req, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Request to [" + String.valueOf(req.uri()) + "] has been interrupted");
        }
    }

    @Override
    public Map<String, Object> loadConfiguration(URI url) throws IOException {
        HttpRequest req = HttpRequest.newBuilder(url).timeout(this.timeout).header("Accept", "application/json").build();
        log.info("Fetching configuration from url [{}]...", (Object)url);
        HttpResponse<InputStream> resp = this.performRequest(req);
        try (InputStream is = resp.body();){
            int statusCode = resp.statusCode();
            if (statusCode != 200) {
                throw new IOException("HTTP error [" + statusCode + "] fetching configuration from URL [" + String.valueOf(url) + "].");
            }
            Map<String, Object> ret = JsonConfigParser.parseConfig(is);
            if (log.isDebugEnabled()) {
                log.debug("Successfully fetched configuration [{}] from URL [{}].", ret, (Object)url);
            } else {
                log.info("Successfully fetched [{}] configuration properties from URL [{}].", (Object)ret.size(), (Object)url);
            }
            Map<String, Object> map = ret;
            return map;
        }
    }

    @Override
    public Map<String, Object> loadStringMap(URI url, String bearerToken) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder(url).timeout(this.timeout).header("Accept", "application/json");
        if (bearerToken != null) {
            builder.header("Authorization", "Bearer " + bearerToken);
        }
        HttpRequest req = builder.build();
        log.info("Fetching string map from url [{}]...", (Object)url);
        HttpResponse<InputStream> resp = this.performRequest(req);
        try (InputStream is = resp.body();){
            int statusCode = resp.statusCode();
            if (statusCode != 200) {
                throw new IOException("HTTP error [" + statusCode + "] fetching string map from URL [" + String.valueOf(url) + "].");
            }
            Map<String, Object> ret = JsonConfigParser.parseStringMap(is);
            if (log.isDebugEnabled()) {
                log.debug("Successfully fetched string map [{}] from URL [{}].", ret, (Object)url);
            } else {
                log.info("Successfully fetched [{}] string map entries from URL [{}].", (Object)ret.size(), (Object)url);
            }
            Map<String, Object> map = ret;
            return map;
        }
    }

    @Override
    public void logout(URI url, String bearerToken) throws IOException {
        HttpRequest req = HttpRequest.newBuilder(url).timeout(this.timeout).header("Accept", "application/json").header("Authorization", "Bearer " + bearerToken).build();
        log.info("Logging out by url [{}]...", (Object)url);
        HttpResponse<InputStream> resp = this.performRequest(req);
        try (InputStream is = resp.body();
             InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            String answer;
            char[] buf = new char[256];
            int n = reader.read(buf, 0, 253);
            if (n < 0) {
                answer = "--empty--";
            } else {
                if (n == 253 && is.available() > 0) {
                    buf[253] = 46;
                    buf[254] = 46;
                    buf[255] = 46;
                    n = 256;
                }
                answer = new String(buf, 0, n);
            }
            log.info("Logout from [{}] returned code [{}] with answer [{}].", new Object[]{url, resp.statusCode(), answer});
        }
    }

    @Override
    public List<JWKPubKey> loadPublicKeys(URI url) throws IOException {
        HttpRequest req = HttpRequest.newBuilder(url).timeout(this.timeout).header("Accept", "application/json").build();
        log.info("Fetching JWK public keys from url [{}]...", (Object)url);
        HttpResponse<InputStream> resp = this.performRequest(req);
        try (InputStream is = resp.body();){
            int statusCode = resp.statusCode();
            if (statusCode != 200) {
                throw new IOException("HTTP error [" + statusCode + "] fetching JWK public keys from URL [" + String.valueOf(url) + "].");
            }
            List ret = JWKeyParser.parsePubKeyList((InputStream)is);
            if (log.isDebugEnabled()) {
                log.debug("Successfully fetched JWK public keys [{}] from URL [{}].", (Object)ret, (Object)url);
            } else {
                log.info("Successfully fetched [{}] JWK public keys from URL [{}].", (Object)ret.size(), (Object)url);
            }
            List list = ret;
            return list;
        }
    }

    private static String formatBasicAuthHeader(PasswordAuthentication clientCredentials) {
        String passwordString = String.valueOf(clientCredentials.getPassword());
        String userString = clientCredentials.getUserName();
        if (userString.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Basic auth user [" + userString + "] contains a colon.");
        }
        String combined = userString + ":" + passwordString;
        String encoded = Base64.getEncoder().encodeToString(combined.getBytes(StandardCharsets.UTF_8));
        String header = "Basic " + encoded;
        return header;
    }

    protected static void appendParam(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(key);
        sb.append("=");
        sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
    }

    private OAuthTokenResponse requestTokenInternal(TokenRequest params) throws IOException, OAuthTokenErrorResponse {
        int statusCode;
        InputStream is;
        URI url;
        block23: {
            url = params.getUrl();
            PasswordAuthentication clientCredentials = params.getClientCredentials();
            String grantType = params.getGrantType();
            String scope = params.getScope();
            String state = params.getState();
            StringBuilder formData = new StringBuilder();
            boolean useBasicAuth = params.getOptions().contains((Object)ConfigOptions.basicAuthCredentials);
            if (log.isDebugEnabled()) {
                log.debug("Using options = {} in requestTokenInternal", params.getOptions());
            }
            if (!useBasicAuth) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending client credentials using body form parameters.");
                }
                OAuthHttpClientImpl.appendParam(formData, "client_id", clientCredentials.getUserName());
                if (clientCredentials.getPassword() != null) {
                    OAuthHttpClientImpl.appendParam(formData, "client_secret", new String(clientCredentials.getPassword()));
                }
            }
            OAuthHttpClientImpl.appendParam(formData, "grant_type", grantType);
            OAuthHttpClientImpl.appendParam(formData, "scope", scope);
            if (params.getRedirectUri() != null) {
                OAuthHttpClientImpl.appendParam(formData, "redirect_uri", params.getRedirectUri());
            }
            for (Map.Entry<String, String> e : params.getAdditionalParameters().entrySet()) {
                OAuthHttpClientImpl.appendParam(formData, e.getKey(), e.getValue());
            }
            if (state != null) {
                OAuthHttpClientImpl.appendParam(formData, "state", state);
            }
            HttpRequest.Builder builder = HttpRequest.newBuilder(url).POST(HttpRequest.BodyPublishers.ofString(formData.toString())).timeout(this.timeout).header("Accept", "application/json").header("Content-Type", "application/x-www-form-urlencoded");
            if (useBasicAuth) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending client credentials using basic auth.");
                }
                builder.header("Authorization", OAuthHttpClientImpl.formatBasicAuthHeader(clientCredentials));
            }
            log.info("Requesting OAuth token from url [{}]...", (Object)url);
            if (log.isDebugEnabled()) {
                log.debug("OAuth token request parameters are [{}].", (Object)formData);
            }
            HttpResponse<InputStream> resp = this.performRequest(builder.build());
            is = resp.body();
            statusCode = resp.statusCode();
            if (log.isDebugEnabled()) {
                log.debug("Received response to [{}] with HTTP status [{}].", (Object)url, (Object)statusCode);
            }
            if (statusCode == 200) {
                try {
                    OAuthTokenResponse ret = OAuthTokenResponseParser.parseResponse(is, params.getRedirectUri(), state, null, this.clock);
                    if (log.isDebugEnabled()) {
                        log.debug("Successfully fetched OAuth token [{}] from URL [{}].", (Object)ret, (Object)url);
                    } else {
                        log.info("Successfully fetched OAuth token from URL [{}].", (Object)url);
                    }
                    OAuthTokenResponse oAuthTokenResponse = ret;
                    return oAuthTokenResponse;
                }
                catch (OAuthTokenErrorResponse e) {
                    log.error("OAuth token request from URL [{}] failed with error [{}].", (Object)url, (Object)e.getMessage());
                    throw e;
                }
            }
            if (statusCode != 400) break block23;
            OAuthTokenErrorResponse ret = OAuthTokenResponseParser.parseErrorResponse(is);
            log.error("OAuth token request from URL [{}] failed with error [{}].", (Object)url, (Object)ret.getMessage());
            throw ret;
        }
        throw new IOException("HTTP error [" + statusCode + "] fetching OAuth token from URL [" + String.valueOf(url) + "].");
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public OAuthTokenResponse requestToken(URI url, String redirectUri, String state, String scope, PasswordAuthentication clientCredentials, String authCode, EnumSet<ConfigOptions> options) throws IOException, OAuthTokenErrorResponse {
        return this.requestTokenInternal(new TokenRequest().url(url).redirectUri(redirectUri).state(state).scope(scope).clientCredentials(clientCredentials).grantType("authorization_code").additionalParameter("code", authCode).options(options));
    }

    @Override
    public OAuthTokenResponse refreshToken(URI url, String redirectUri, String state, String scope, PasswordAuthentication clientCredentials, String refreshToken, EnumSet<ConfigOptions> options) throws IOException, OAuthTokenErrorResponse {
        OAuthTokenResponse resp = this.requestTokenInternal(new TokenRequest().url(url).redirectUri(redirectUri).state(state).scope(scope).clientCredentials(clientCredentials).grantType("refresh_token").additionalParameter("refresh_token", refreshToken).options(options));
        if (resp.getRefreshToken() == null) {
            return new OAuthTokenResponse(resp.getAccessToken(), resp.getTokenType(), resp.getExpiresIn(), resp.getScope(), refreshToken, resp.getIdToken(), resp.getRedirectUri(), resp.getState(), this.clock);
        }
        return resp;
    }

    @Override
    public OAuthTokenResponse requestRobotToken(URI url, String scope, PasswordAuthentication clientCredentials, EnumSet<ConfigOptions> options) throws IOException, OAuthTokenErrorResponse {
        RobotGrantType grantType = RobotGrantType.client_credentials;
        TokenRequest basicRequest = new TokenRequest().url(url).scope(scope).clientCredentials(clientCredentials).grantType(grantType.toString()).options(options);
        return this.requestTokenInternal(basicRequest);
    }

    @Override
    public OAuthTokenResponse requestPasswordFlowToken(URI url, String scope, PasswordAuthentication clientCredentials, PasswordAuthentication resourceOwnerCredentials, EnumSet<ConfigOptions> options) throws IOException, OAuthTokenErrorResponse {
        RobotGrantType grantType = RobotGrantType.password;
        TokenRequest basicRequest = new TokenRequest().url(url).scope(scope).clientCredentials(clientCredentials).grantType(grantType.toString()).options(options).additionalParameter("username", resourceOwnerCredentials.getUserName()).additionalParameter("password", new String(resourceOwnerCredentials.getPassword()));
        return this.requestTokenInternal(basicRequest);
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void shutdown() {
        this.client = null;
    }

    private static class TokenRequest {
        private URI url;
        private String redirectUri;
        private String state;
        private String scope;
        private PasswordAuthentication clientCredentials;
        private String grantType;
        private String codeKey;
        private String code;
        private Map<String, String> additionalParameters = new HashMap<String, String>();
        private EnumSet<ConfigOptions> options;

        private TokenRequest() {
        }

        public URI getUrl() {
            return this.url;
        }

        public TokenRequest url(URI _url) {
            this.url = _url;
            return this;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public TokenRequest redirectUri(String _redirectUri) {
            this.redirectUri = _redirectUri;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public TokenRequest state(String _state) {
            this.state = _state;
            return this;
        }

        public String getScope() {
            return this.scope;
        }

        public TokenRequest scope(String _scope) {
            this.scope = _scope;
            return this;
        }

        public PasswordAuthentication getClientCredentials() {
            return this.clientCredentials;
        }

        public TokenRequest clientCredentials(PasswordAuthentication _clientCredentials) {
            this.clientCredentials = _clientCredentials;
            return this;
        }

        public String getGrantType() {
            return this.grantType;
        }

        public TokenRequest grantType(String _grantType) {
            this.grantType = _grantType;
            return this;
        }

        public String getCodeKey() {
            return this.codeKey;
        }

        public TokenRequest codeKey(String _codeKey) {
            this.codeKey = _codeKey;
            return this;
        }

        public String getCode() {
            return this.code;
        }

        public TokenRequest code(String _code) {
            this.code = _code;
            return this;
        }

        public Map<String, String> getAdditionalParameters() {
            return this.additionalParameters;
        }

        public TokenRequest additionalParameter(String key, String value) {
            this.additionalParameters.put(key, value);
            return this;
        }

        public EnumSet<ConfigOptions> getOptions() {
            return this.options;
        }

        public TokenRequest options(EnumSet<ConfigOptions> _options) {
            this.options = _options;
            return this;
        }
    }
}

