/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Arrays;
import org.clazzes.login.jbo.json.JsonHelper;
import org.clazzes.login.oauth.OAuthTokenErrorResponse;
import org.clazzes.login.oauth.OAuthTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenResponseParser {
    private static final Logger log = LoggerFactory.getLogger(OAuthTokenResponseParser.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    private static OAuthTokenErrorResponse parseErrorInternal(JsonParser reader, String name) throws IOException {
        String ctxt = "oauth-error";
        String error = null;
        String errorDescription = null;
        String errorUri = null;
        String timestamp = null;
        String traceId = null;
        String correlationId = null;
        long[] errorCodes = null;
        while (name != null || (name = JsonHelper.nextName((JsonParser)reader, (String)ctxt)) != null) {
            if ("error".equals(name)) {
                error = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("error_description".equals(name)) {
                errorDescription = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("error_uri".equals(name)) {
                errorUri = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("timestamp".equals(name)) {
                timestamp = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("trace_id".equals(name)) {
                traceId = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("correlation_id".equals(name)) {
                correlationId = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
            } else if ("error_codes".equals(name)) {
                long[] tmp = new long[32];
                int ncodes = 0;
                JsonHelper.beginArray((JsonParser)reader, (String)ctxt);
                while (reader.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                    long code = reader.getLongValue();
                    if (ncodes >= tmp.length) {
                        log.warn("Ignoring additonal error code [{}] (only 32 error codes are accepted in OAuth token error responses).", (Object)code);
                    } else {
                        tmp[ncodes] = code;
                    }
                    ++ncodes;
                }
                JsonHelper.endArray((JsonParser)reader, (String)ctxt);
                errorCodes = Arrays.copyOf(tmp, ncodes);
            } else {
                log.warn("Ignoring unknown property [{}] in OAuth token response.", (Object)name);
                reader.nextToken();
                reader.skipChildren();
            }
            name = null;
        }
        JsonHelper.endObject((JsonParser)reader, (String)ctxt);
        return new OAuthTokenErrorResponse(error, errorDescription, errorUri, timestamp, traceId, correlationId, errorCodes);
    }

    public static OAuthTokenResponse parseResponse(InputStream is, String redirectUri, String state, String refreshToken, Clock clock) throws IOException, OAuthTokenErrorResponse {
        String ctxt = "oauth-token-response";
        try (JsonParser reader = JSON_FACTORY.createParser(is);){
            String name;
            String accessToken = null;
            String tokenType = null;
            Long expiresIn = null;
            String scope = null;
            String idToken = null;
            JsonHelper.beginObject((JsonParser)reader, (String)ctxt);
            while ((name = JsonHelper.nextName((JsonParser)reader, (String)ctxt)) != null) {
                if ("error".equals(name) || "error_description".equals(name)) {
                    throw OAuthTokenResponseParser.parseErrorInternal(reader, name);
                }
                if ("access_token".equals(name)) {
                    accessToken = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                    continue;
                }
                if ("token_type".equals(name)) {
                    tokenType = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                    continue;
                }
                if ("expires_in".equals(name)) {
                    expiresIn = JsonHelper.nextLong((JsonParser)reader, (String)ctxt) * 1000L;
                    continue;
                }
                if ("scope".equals(name)) {
                    scope = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                    continue;
                }
                if ("refresh_token".equals(name)) {
                    refreshToken = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                    continue;
                }
                if ("id_token".equals(name)) {
                    idToken = JsonHelper.nextString((JsonParser)reader, (String)ctxt);
                    continue;
                }
                log.warn("Ignoring unknown property [{}] in OAuth token response.", (Object)name);
                reader.nextToken();
                reader.skipChildren();
            }
            JsonHelper.endObject((JsonParser)reader, (String)ctxt);
            OAuthTokenResponse oAuthTokenResponse = new OAuthTokenResponse(accessToken, tokenType, expiresIn, scope, refreshToken, idToken, redirectUri, state, clock);
            return oAuthTokenResponse;
        }
    }

    public static OAuthTokenErrorResponse parseErrorResponse(InputStream is) throws IOException {
        String ctxt = "oauth-error-response";
        try (JsonParser reader = JSON_FACTORY.createParser(is);){
            JsonHelper.beginObject((JsonParser)reader, (String)ctxt);
            OAuthTokenErrorResponse oAuthTokenErrorResponse = OAuthTokenResponseParser.parseErrorInternal(reader, null);
            return oAuthTokenErrorResponse;
        }
    }
}

