/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.login.oauth.AuthState;
import org.clazzes.login.oauth.ConfigOptions;
import org.clazzes.login.oauth.DomainConfig;
import org.clazzes.login.oauth.DomainManager;
import org.clazzes.login.oauth.OAuthAbstrServlet;
import org.clazzes.login.oauth.i18n.OAuthMessages;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.http.LocaleHelper;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthStartServlet
extends OAuthAbstrServlet {
    private static final long serialVersionUID = 6376913713678650071L;
    private static final Logger log = LoggerFactory.getLogger(OAuthStartServlet.class);

    protected void writeRedirect(Messages i18n, HttpServletResponse resp, String css, String domain, String authorizationUri, String state) throws IOException, ServletException {
        try {
            String lang = LocaleHelper.toXsLanguage((Locale)i18n.getLocale());
            resp.setHeader("X-Frame-Options", "SAMEORIGIN");
            resp.setHeader("Content-Language", lang);
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("application/xhtml+xml");
            resp.getOutputStream().write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n".getBytes("UTF-8"));
            XMLStreamWriter xsw = xmlOutputFactory.createXMLStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            xsw.setDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeAttribute("lang", lang);
            xsw.writeAttribute("xml:lang", lang);
            xsw.writeStartElement("head");
            xsw.writeEmptyElement("meta");
            xsw.writeAttribute("http-equiv", "Content-Type");
            xsw.writeAttribute("content", "application/xhtml+xml");
            xsw.writeEmptyElement("link");
            xsw.writeAttribute("type", "text/css");
            xsw.writeAttribute("rel", "stylesheet");
            xsw.writeAttribute("href", css == null ? "oauth-login.css" : css);
            xsw.writeStartElement("script");
            xsw.writeCharacters("\nvar reloadUri = function() { window.location.href='" + authorizationUri + "';};\n");
            xsw.writeCharacters("\nsetTimeout(reloadUri,100);\n");
            xsw.writeEndElement();
            xsw.writeStartElement("title");
            xsw.writeCharacters("OAuth Single-Sign-On");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("form");
            xsw.writeAttribute("id", "loginStateForm");
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "state");
            xsw.writeAttribute("value", state);
            xsw.writeEndElement();
            xsw.writeStartElement("p");
            xsw.writeCharacters(i18n.formatString("redirecting-to", new Object[]{domain}));
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.close();
            resp.flushBuffer();
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error setting XML stream writer", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI requestURI;
        String pi = req.getPathInfo();
        try {
            requestURI = RequestHelper.getOriginalRequestUri((HttpServletRequest)req);
        }
        catch (URISyntaxException | ParseException e) {
            throw new ServletException("Unable to parse full request URI for request to [" + RequestHelper.getRequestUrl((HttpServletRequest)req) + "]", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Received request to [{}]", (Object)requestURI);
        }
        if (pi == null) {
            String domain = req.getParameter("domain");
            DomainManager domainManager = this.configurationService.getDomainManager(domain);
            DomainConfig domainConfig = domainManager.getDomainConfig();
            if (domainConfig == null) {
                log.info("Received request to [{}] with invalid domain parameter.", (Object)requestURI);
                resp.sendError(400);
                return;
            }
            String state = req.getParameter("state");
            if (state == null) {
                log.info("Received request to [{}] without state parameter.", (Object)requestURI);
                resp.sendError(400);
                return;
            }
            AuthState authState = this.authStateCache.getAuthState(state);
            if (authState == null) {
                log.info("Received request to [{}] with invalid or expired state parameter.", (Object)requestURI);
                resp.sendError(400);
                return;
            }
            String css = req.getParameter("css");
            Locale locale = OAuthStartServlet.getRequestLocale(req);
            Messages i18n = OAuthMessages.getMesssages(locale);
            authState.init(domain, System.currentTimeMillis() + 900000L);
            URI au = domainConfig.getAuthorizationLocation();
            PasswordAuthentication pa = domainConfig.getClientCredentials();
            try {
                if (au == null) {
                    au = domainManager.getOpenIdLocation("authorization_endpoint");
                }
                if (au == null) {
                    throw new ServletException("No authorization URI given by OpenID configuration for domain [" + domainConfig.getDomain() + "] or OpenID configuration not yet loaded.");
                }
                URI redirectUri = new URI(requestURI.getScheme(), requestURI.getUserInfo(), requestURI.getHost(), requestURI.getPort(), this.oauthHttpLoginService.getRedirectUrl(), null, requestURI.getFragment());
                String authorizationUri = au.toString();
                if (domainConfig.getOptions().contains((Object)ConfigOptions.reverseProxyIntegrated)) {
                    URI proxyAu = new URI(requestURI.getScheme(), requestURI.getUserInfo(), requestURI.getHost(), requestURI.getPort(), au.getPath(), au.getQuery(), au.getFragment());
                    log.info("Using proxied authorization URI [{}] instead of [{}]", (Object)proxyAu, (Object)au);
                    authorizationUri = proxyAu.toString();
                } else {
                    authorizationUri = au.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Raw authorization URI is [{}].", (Object)authorizationUri);
                    log.debug("Raw redirect URI is [{}].", (Object)redirectUri);
                }
                authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"client_id", (String)pa.getUserName());
                authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"response_type", (String)"code");
                authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"redirect_uri", (String)redirectUri.toString());
                if (domainConfig.getScope() != null) {
                    authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"scope", (String)domainConfig.getScope());
                }
                if (domainConfig.getPrompt() != null) {
                    authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"prompt", (String)domainConfig.getPrompt());
                }
                if (domainConfig.getAccessType() != null) {
                    authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"access_type", (String)domainConfig.getAccessType());
                }
                if (domainConfig.getResource() != null) {
                    authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"resource", (String)domainConfig.getResource());
                }
                if (domainConfig.getOptions().contains((Object)ConfigOptions.propagateLocale)) {
                    authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"locale", (String)LocaleHelper.toXsLanguage((Locale)locale));
                }
                authorizationUri = UrlHelper.appendQueryParameterToUrl((String)authorizationUri, (String)"state", (String)authState.getState());
                if (log.isDebugEnabled()) {
                    log.debug("Using full authorization URI [{}].", (Object)authorizationUri);
                }
                this.writeRedirect(i18n, resp, css, authState.getDomain(), authorizationUri, authState.getState());
            }
            catch (URISyntaxException e) {
                throw new ServletException("Error assembling redirect or authorization URI", (Throwable)e);
            }
            catch (IllegalStateException e) {
                log.error("OpenID configuration of domain [" + domainConfig.getDomain() + "] not loaded while requesting authorization location", (Throwable)e);
                resp.sendError(400);
                return;
            }
        } else {
            resp.sendError(404);
        }
    }

    public String getServletInfo() {
        return OAuthStartServlet.class.getSimpleName();
    }
}

