/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.oauth;

import jakarta.servlet.Servlet;
import java.util.regex.Pattern;
import org.clazzes.login.oauth.AuthStateCache;
import org.clazzes.login.oauth.ConfigurationService;
import org.clazzes.login.oauth.GarbageCollector;
import org.clazzes.login.oauth.LoginInfoCache;
import org.clazzes.login.oauth.OAuthAuthServlet;
import org.clazzes.login.oauth.OAuthHttpLoginService;
import org.clazzes.login.oauth.OAuthLoginServlet;
import org.clazzes.login.oauth.OAuthStartServlet;
import org.clazzes.login.oauth.SameSitePolicy;
import org.clazzes.login.oauth.TokenGenerator;
import org.clazzes.login.oauth.TokenType;
import org.clazzes.login.oauth.impl.JWTokenValidator;
import org.clazzes.login.oauth.impl.OAuthHttpClientImpl;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.http.AdditionalHeader;
import org.clazzes.util.http.ResourceServlet;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthLoginComponent
extends ComponentSupport
implements Component {
    private static final Logger log = LoggerFactory.getLogger(OAuthLoginComponent.class);
    public static final String LOGIN_MECHANISM = "org.clazzes.login.oauth";
    private static final int DEFAULT_SESSION_TIMEOUT = 180;
    private static final String DEFAULT_SESSION_COOKIE = "OAUTH_SESSION_ID";
    private static final boolean DEFAULT_SECURE_COOKIE = false;
    private static final SameSitePolicy DEFAULT_SAME_SITE_POLICY = SameSitePolicy.Strict;
    private static final TokenType DEFAULT_DELEGATE_TOKEN_TYPE = TokenType.OPAQUE;
    private GarbageCollector gc;

    public void start(ServiceContext context) throws Exception {
        CoreService cs = (CoreService)context.getService(CoreService.class).get();
        ServiceRegistry serviceRegistry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        ConfigurationEngine ce = (ConfigurationEngine)context.getService(ConfigurationEngine.class).get();
        ComponentManager componentManager = (ComponentManager)context.getService(ComponentManager.class).get();
        OAuthHttpClientImpl httpClient = new OAuthHttpClientImpl();
        TokenGenerator tokenGenerator = new TokenGenerator();
        LoginInfoCache lic = new LoginInfoCache();
        lic.setTokenGenerator(tokenGenerator);
        AuthStateCache asc = new AuthStateCache();
        asc.setTokenGenerator(tokenGenerator);
        this.gc = new GarbageCollector();
        this.gc.setAuthStateCache(asc);
        this.gc.setLoginInfoCache(lic);
        JWTokenValidator tokenValidator = new JWTokenValidator();
        ConfigurationService configurationService = new ConfigurationService(serviceRegistry);
        configurationService.setOauthHttpClient(httpClient);
        configurationService.setTokenValidator(tokenValidator);
        this.addListener(ce.listen(LOGIN_MECHANISM, config -> {
            OAuthLoginComponent oAuthLoginComponent = this;
            synchronized (oAuthLoginComponent) {
                this.removeAllServices(serviceRegistry);
                configurationService.accept((ConfigWrapper)config);
                this.gc.executorServiceBound(cs.getScheduledExecutorService());
                int sessionTimeout = config.getInt("sessionTimeout", 180);
                String sessionCookie = config.getString("sessionCookie", DEFAULT_SESSION_COOKIE);
                boolean secureCookie = config.getBoolean("secureCookie", false);
                SameSitePolicy sameSitePolicy = (SameSitePolicy)config.getEnum(SameSitePolicy.class, "sameSitePolicy", (Enum)DEFAULT_SAME_SITE_POLICY);
                String delegateDomain = config.getString("delegateDomain");
                TokenType delegateTokenType = (TokenType)config.getEnum(TokenType.class, "delegateTokenType", (Enum)DEFAULT_DELEGATE_TOKEN_TYPE);
                String alternativeMechanism = config.getString("alternativeMechanism");
                String alternativeLabel = config.getString("alternativeLabel");
                String alternativeIconLocation = config.getString("alternativeIconLocation");
                OAuthHttpLoginService loginService = new OAuthHttpLoginService(serviceRegistry);
                loginService.setAlternativeMechanism(alternativeMechanism);
                loginService.setConfigurationService(configurationService);
                loginService.setDelegateDomain(delegateDomain);
                loginService.setDelegateTokenType(delegateTokenType);
                loginService.setLoginInfoCache(lic);
                loginService.setOauthHttpClient(httpClient);
                loginService.setSameSitePolicy(sameSitePolicy);
                loginService.setSecureCookie(secureCookie);
                loginService.setSessionCookie(sessionCookie);
                loginService.setSessionTimeout(sessionTimeout);
                loginService.setTokenValidator(tokenValidator);
                this.addService(serviceRegistry, LOGIN_MECHANISM, HttpLoginService.class, loginService);
                OAuthStartServlet startServlet = new OAuthStartServlet();
                startServlet.setAuthStateCache(asc);
                startServlet.setConfigurationService(configurationService);
                startServlet.setOauthHttpClient(httpClient);
                startServlet.setOauthHttpLoginService(loginService);
                this.addService(serviceRegistry, "/oauth-login/start", Servlet.class, (Object)startServlet);
                OAuthAuthServlet authServlet = new OAuthAuthServlet();
                authServlet.setAuthStateCache(asc);
                authServlet.setConfigurationService(configurationService);
                authServlet.setOauthHttpClient(httpClient);
                authServlet.setOauthHttpLoginService(loginService);
                this.addService(serviceRegistry, "/oauth-login/auth", Servlet.class, (Object)authServlet);
                OAuthLoginServlet loginServlet = new OAuthLoginServlet();
                loginServlet.setAlternativeIconLocation(alternativeIconLocation);
                loginServlet.setAlternativeLabel(alternativeLabel);
                loginServlet.setAuthStateCache(asc);
                loginServlet.setConfigurationService(configurationService);
                loginServlet.setOauthHttpClient(httpClient);
                loginServlet.setOauthHttpLoginService(loginService);
                this.addService(serviceRegistry, "/oauth-login/login", Servlet.class, (Object)loginServlet);
                ResourceServlet resourceServlet = new ResourceServlet();
                resourceServlet.setMaxAgeSeconds(3600);
                resourceServlet.addAdditionalHeader(new AdditionalHeader("X-Frame-Options", "SAMEORIGIN", null, Pattern.compile("text/html")));
                resourceServlet.setResourceModule(OAuthLoginServlet.class.getModule());
                resourceServlet.setResourcePath("/META-INF/webapp/oauth-login");
                resourceServlet.addExcludeMimeType("image/png");
                resourceServlet.addExcludeMimeType("image/gif");
                resourceServlet.addExcludeMimeType("image/jpeg");
                resourceServlet.addExcludeMimeType("image/tiff");
                this.addService(serviceRegistry, "/oauth-login/*", Servlet.class, resourceServlet);
            }
        }));
        componentManager.commit();
    }

    public void stop(ServiceContext context) throws Exception {
        if (this.gc != null) {
            this.gc.executorServiceUnbound();
            this.gc = null;
        }
        this.closeAllListeners((c, e) -> log.warn("Error closing OAuth listener [{}]", c, e));
        ServiceRegistry serviceRegistry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        this.removeAllServices(serviceRegistry);
    }
}

